/*******************************************************************************
  Copyright (c) 2013 by Turku PET Centre (TPC)

  File:         libtpctaciov.c  
  Purpose:      functions for printing the information on the library. 
  Version:      See the LIB_VERSION and history below.

*******************************************************************************/

/******************************************************************************/

/** Library name. */
#define LIB_NAME "libtpctacio"

/** Library version. */
#define LIB_VERSION "0.0.1"

/** Copyright. */
#define COPYRIGHT "(c) 2013 by Turku PET Centre, University of Turku"

/******************************************************************************/
#include <stdio.h>
#include "include/libtpctaciov.h"
/******************************************************************************/

/******************************************************************************/
/** 
    Print the library History to specified FILE pointer, 
    use stdout for screen.
*/
void libtpctacio_print_history(FILE *fp)
{
  fputs(
  " \n"
  "2013-09-18 version 0.0.1 Vesa Oikonen\n"
  "  First created, based on libtpccurveio 2.4.6.\n"
  "\n", fp);
  fflush(fp);
}
/******************************************************************************/
/** 
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpctacio_print_readme(FILE *fp)
{
  fputs(
  "\n"
  LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
  "\n"
  "Build "__DATE__" "__TIME__"\n"
  "\n"
  "\n"
  "PET time-activity curve (TAC) IO library\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "Library is distributed under the GNU Lesser General Public Licence\n"
  "http://www.turkupetcentre.net/software/lgpl-license.html\n"
  "More information on open source licences: http://www.opensource.org\n"
  "\n"
  "Description\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "The "LIB_NAME" library contains methods for processing regional and input\n"
  "TAC data and modelling results obtained from those at Turku PET Centre.\n"
  "\n"
  "List of files\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "Doxyfile        - Doxygen configuration file.\n"
  "include/        - Includes all the header files for the .c files\n"
  "Makefile        - The makefile\n"
  "Makefile32      - The makefile to compile 32-bit executables on 64-bit OS\n"
  "\n"
  "** .c files **\n"
  "\n"
  "libtpctacio.c   - Functions for running tests on "LIB_NAME".\n"
  "libtpctaciov.c  - Functions for printing information on this library.\n"
  "par.c           - Data processing functions for parameter files.\n"
  "pario.c         - General I/O functions for parameter files.\n"
  "parcsv.c        - I/O functions for parameter files in CSV format.\n"
  "parfit.c        - I/O functions for parameter files in FIT format.\n"
  "parres.c        - I/O functions for parameter files in RES format.\n"
  "tac.c           - Data processing functions for TAC files.\n"
  "taccomp.c       - Comparison of TAC data.\n"
  "taccsv.c        - I/O functions for TAC files in CSV format.\n"
  "tacdecay.c      - Correction of physical decay for TAC data.\n"
  "tacdft.c        - I/O functions for TAC files in DFT format.\n"
  "tacio.c         - General I/O functions for TAC files.\n"
  "tacpmod.c       - I/O functions for TAC files in PMOD format.\n"
  "tacsimp.c       - I/O functions for TAC files in simple ASCII format.\n"
  "\n"
  "Using the library\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "The program that uses the library should include the .h file it needs.\n"
  "Example 1:\n"
  "    \\#include <tacio.h>  // includes all library functions\n"
  "\n"
  "libtpctacio is dependent on the following TPC libraries:\n"
  "    libtpcmisc\n"
  "\n"
  "Example:\n"
  "    gcc myprog.c -ltpctacio -ltpcmisc -lm\n"
  "\n", fp);

  fflush(fp);
}

/******************************************************************************/
/** 
    Print the library Readme to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpctacio_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<pre>\n",
    LIB_NAME, LIB_VERSION, COPYRIGHT);
  libtpctacio_print_readme(fp);
  fprintf(fp,"\n</pre> \n */\n");
}

/******************************************************************************/
/** 
    Print the library History to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpctacio_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<pre>\n");
  libtpctacio_print_history(fp);
  fprintf(fp,"\n</pre> \n */\n");
}

/******************************************************************************/
/** 
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpctacio_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n", LIB_NAME, LIB_VERSION, COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n", __DATE__, __TIME__);
#ifdef __STRICT_ANSI__
  fprintf(fp," (ANSI compatible build)\n");
#endif
#if defined(__FILE__) && defined(__TIMESTAMP__)
  printf(" File %s last edited on %s\n", __FILE__, __TIMESTAMP__);
#endif
#if defined(__STDC_VERSION__)
  printf(" Version of C: %ld\n", __STDC_VERSION__);
#endif
#if defined(__STDC_ISO_10646__)
  printf(" Compiler ISO/IEC 10646 specification: %ld\n", __STDC_ISO_10646__);
#endif
#if defined(__GNUC__) && defined(__VERSION__)
  printf(" GNU C version: %s\n", __VERSION__);
#endif
#ifdef _OPENMP
  printf(" OpenMP version: %d\n", _OPENMP);
#endif
#if defined(__x86_64__) || defined(__LP64__) || defined(__ppc64__)
  printf(" Architecture: 64-bit\n");
#else
  printf(" Architecture: 32-bit\n");
#endif
  printf(" Size of long double: %d bits\n", 8*(int)sizeof(long double));
#if defined(FLT_EVAL_METHOD)
  printf(" FLT_EVAL_METHOD: %d\n", FLT_EVAL_METHOD);
#endif
}
/******************************************************************************/

/******************************************************************************/
