/******************************************************************************
  Copyright (c) 2013 by Turku PET Centre

  File:        tacsort.c
  Description: Functions for sorting data in TAC or PAR struct.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details:
  http://www.gnu.org/copyleft/lesser.html

  You should have received a copy of the GNU Lesser General Public License
  along with this library/program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

  Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi

  Modification history:
  2013-09-25 Vesa Oikonen
       First created.
     


******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "libtpcmisc.h"
/*****************************************************************************/
#include "include/tacio.h"
/*****************************************************************************/

/*****************************************************************************/
/** Sort samples (frames) in TAC struct by increasing sample time.
\return Returns TACIO status.
 */
int tacSortByFrame(
  /** Pointer to TAC struct */
  TAC *d
) {
  /* Check that required data exists */
  if(d==NULL || d->voiNr<1) return TACIO_FAULT;
  /* All sample times must be available */
  if(tacFrameNaNs(d)>0) return TACIO_NAN;
  if(d->frameNr<1) return TACIO_OK;
  
  TACVOI *t;
  int ri, fi, fj;
  double s, a1, a2;
  for(fi=0; fi<d->frameNr-1; fi++) for(fj=fi+1; fj<d->frameNr; fj++) {
    if(d->isframe==0) {a1=d->x[fi]; a2=d->x[fj];}
    else {a1=0.5*(d->x1[fi]+d->x2[fi]); a2=0.5*(d->x1[fj]+d->x2[fj]);}
    if(a2>=a1) continue;
    s=d->x[fi];  d->x[fi]=d->x[fj];   d->x[fj]=s;
    s=d->x1[fi]; d->x1[fi]=d->x1[fj]; d->x1[fj]=s;
    s=d->x2[fi]; d->x2[fi]=d->x2[fj]; d->x2[fj]=s;
    s=d->w[fi];  d->w[fi]=d->w[fj];   d->w[fj]=s;
    for(ri=0; ri<d->voiNr; ri++) {
      t=d->voi+ri;
      s=t->y[fi];  t->y[fi]=t->y[fj];   t->y[fj]=s;
      s=t->y2[fi]; t->y2[fi]=t->y2[fj]; t->y2[fj]=s;
      s=t->y3[fi]; t->y3[fi]=t->y3[fj]; t->y3[fj]=s;
    }
  }  
  return TACIO_OK;
}
/*****************************************************************************/

/*****************************************************************************/
/** Local function */
int tacQSortName(const void *voi1, const void *voi2)
{
  int res;

  res=strcasecmp( ((TACVOI*)voi1)->id.name, ((TACVOI*)voi2)->id.name );
  return(res);
}
/** Sort TAC VOIs in alphabetical order by their id name.
\return Returns TACIO status.
 */
int tacSortByName(
  /** Pointer to TAC struct */
  TAC *d
) {
  /* Check that required data exists */
  if(d==NULL) return TACIO_FAULT;
  if(d->voiNr<2) return TACIO_OK;
  qsort(d->voi, d->voiNr, sizeof(TACVOI), tacQSortName);
  return TACIO_OK;
}
/*****************************************************************************/

/*****************************************************************************/
