#!/bin/bash
FILES=*
cd ./bin/
if [ $? -ne 0 ]
then 
  printf "\nError: ./bin folder not found\n" ; exit 1 ; 
fi

if [ -d ../doc ]
then 
  printf "\ndoc folder exists\n"; 
else 
  mkdir ../doc
fi

if [ -e ../doc/index.html ] 
then
  rm ../doc/index.html
fi

printf "<!DOCTYPE html>\n" > ../doc/index.html
printf "<html>\n" >> ../doc/index.html
printf "<head>\n" >> ../doc/index.html
printf "  <meta charset="UTF-8">\n" >> ../doc/index.html
printf "  <title>tpcclib applications</title>\n" >> ../doc/index.html

printf "  <style>\n" >> ../doc/index.html
printf "  .containter {\n" >> ../doc/index.html
printf "    width: 500px;\n" >> ../doc/index.html
printf "  }\n" >> ../doc/index.html
printf "  .containter div {\n" >> ../doc/index.html
printf "    width: 100px;\n" >> ../doc/index.html
printf "    float: left;\n" >> ../doc/index.html
printf "    padding: 5px 0px;\n" >> ../doc/index.html
printf "    font-family: monospace;\n" >> ../doc/index.html
printf "  }\n" >> ../doc/index.html
printf "  </style>\n" >> ../doc/index.html

printf "  <meta name=\"keywords\" content=\"MODELING, ANALYSIS\n" >> ../doc/index.html
printf "  SOFTWARE, PROGRAMS, WINDOWS, MACOS, LINUX, UBUNTU,\n" >> ../doc/index.html
printf "  TPC, TPCCLIB, TURKU, POSITRON EMISSION TOMOGRAPHY\" />\n" >> ../doc/index.html
printf "  <meta name=\"description\" content=\"List of TPC software\" />\n" >> ../doc/index.html

printf "</head>\n" >> ../doc/index.html
printf "<body>\n" >> ../doc/index.html

printf "<!-- THIS HTML FILE IS AUTOMATICALLY CREATED - DO NOT EDIT -->\n" >> ../doc/index.html

printf "<h1>List of applications in TPCCLIB</h1>\n" >> ../doc/index.html

printf "<p>Download the listed applications for Windows, macOS, and Linux from \n" >> ../doc/index.html
printf "<a href=\"https://www.dropbox.com/sh/l22cilo1ze25rj4/RoJiiLh2Q7\">Dropbox</a>, \n" >> ../doc/index.html
printf "<a href=\"https://seafile.utu.fi/d/15843078fb/\">seafile.utu.fi</a>, or\n" >> ../doc/index.html
printf "<a href=\"https://1drv.ms/u/s!At2-B4twnc-loADgwe__5uL5noRq?e=Lc3GRk\">OneDrive</a>.\n" >> ../doc/index.html
printf "</p>\n" >> ../doc/index.html
printf "<p>Download source code from \n" >> ../doc/index.html
printf "<a href=\"https://gitlab.utu.fi/vesoik/tpcclib/-/releases\">GitLab</a>.</p>\n" >> ../doc/index.html



printf "<div class=\"containter\">\n" >> ../doc/index.html

for f in $FILES
do
if [[ "$f" != lib* ]]
then
  ls -al $f
  ./$f --helphtml > ../doc/"${f%.*}".html
  printf "  <div><a href=\""${f%.*}".html\">"${f%.*}"</a></div>\n" >> ../doc/index.html
fi
done

printf "</div>\n" >> ../doc/index.html

printf "</body>\n" >> ../doc/index.html
printf "</html>\n" >> ../doc/index.html

