#!/bin/bash
FILES=*
cd ./bin/
if [ $? -ne 0 ]
then 
  printf "\nError: ./bin folder not found\n" ; exit 1 ; 
fi

if [ -d ../ver ]
then 
  printf "\nver folder exists\n"; 
else 
  mkdir ../ver
fi

for f in $FILES
do
if [[ "$f" != lib* ]]
then
#  ls -al $f
  cp -f $f ../ver/
  ./$f --version > ../ver/"${f%.*}".txt
  iftren --silent ../ver/"${f%.*}".txt "tpcclib version" "version"
  addvers ../ver/"${f%.*}".txt ../ver/$f
  rm -f ../ver/"${f%.*}".txt
fi
done
