TPCCLIB source code documentation
=================================

## Project ##

Tpcclib project is to develop and maintain 
[command-line](http://www.turkupetcentre.net/petanalysis/analysis_shell.html) tools
to [processing and analyzing](http://www.turkupetcentre.net/petanalysis/analysis_process.html) 
data collected in [Turku PET Centre](http://www.turkupetcentre.fi) (TPC),
[University of Turku](http://www.utu.fi/en/).
We hope that some of [tools](http://www.turkupetcentre.net/petanalysis/tpcclib/doc/index.html) may 
be useful also for other research centres working with positron emission tomography.

* [Installing TPCCLIB](install.md)
* [Testing TPCCLIB](testing.md)
* [Packaging TPCCLIB](packaging.md)
* [Changes from previous versions](changelog.md)
* [TPCCLIB Coding Practice](codingpractice.md)
* [Authors of TPCCLIB](authors.md)

Source codes are stored in repository
[gitlab.utu.fi/vesoik/tpcclib](https://gitlab.utu.fi/vesoik/tpcclib/-/releases).

## TPCCLIB folders v1 and v2 ##

The two folders, [v1](http://www.turkupetcentre.net/tpcclib-doc/v1/index.html) and 
[v2](http://www.turkupetcentre.net/tpcclib-doc/v2/index.html), contain different versions of 
C libraries, which are not dependent on each other. 
Both folders contain also source code for 
[applications](http://www.turkupetcentre.net/petanalysis/tpcclib/doc/index.html),
which are mostly not dependent on the libraries in the other folder. 
However, [testing](testing.md) routines of the applications requires that all applications 
can be found in the platforms search path.

[Folder v1](http://www.turkupetcentre.net/tpcclib-doc/v1/index.html) contains the C library that 
has been developed from year 1991, and can be built with [CMake](http://www.cmake.org) 
cross-platform build environment in Linux, macOS, and MS Windows (with msys and mingw-w64). 
Library functions are not formally tested, but applications have at least some basic tests included, 
and since they are already used for a long time, they are generally working reliably.

[Folder v2](http://www.turkupetcentre.net/tpcclib-doc/v2/index.html) contains rewritten versions of 
the C library functions and applications, including at least minimal testing for each library 
function and application. 
Currently the v2 library does not contain all of the functionalities of the v1 library, and 
therefore many applications have not been added there.

## License ##

This program library is free software; you can [redistribute](copying.md) it and/or modify 
it under the terms of the GNU General Public License as published by the Free Software Foundation; 
either version 3 of the License, or (at your option) any later version.

This program library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.

See the [GNU General Public License](license.md) for more details.


    Turku PET Centre hereby disclaims all copyright interest in the program library.

    Juhani Knuuti
    Director, Professor  
    Turku PET Centre
    Turku, Finland

![GPL 3.0](./gplv3-127x51.png)
