#!/bin/bash
#: Title      : test_ecat2ana
#: Date       : 2014-09-21
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../ecat2ana$EXT;

# Make sure that environment variable for flipping is not set
ANALYZE_FLIP=;
export ANALYZE_FLIP
printf "\n ANALYZE_FLIP = %s\n\n", $ANALYZE_FLIP


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f image1.dat ] || [ ! -f image1.inf ] || [ ! -f image1.fra ] ; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f image2.dat ] || [ ! -f image2.inf ] || [ ! -f image2.fra ] ; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f ecat6.img ] || [ ! -f ecat7.v ] ; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f prev_ecat6.hdr ] || [ ! -f prev_ecat6.img ] || [ ! -f prev_ecat6.sif ] ; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f prev_ecat7.hdr ] || [ ! -f prev_ecat7.img ] || [ ! -f prev_ecat7.sif ] ; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi


if [ ! -f image1.v ] || [ ! -f image1.img ]; then
  printf "\n making image1.v and image1.img\n"
  asc2flat image1.dat image1.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=Adv -inf=image1.inf image1.bin image1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe image1.v image1.fra
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 image1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt image1.v 2007-03-20 15:22:02
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb image1.v image1.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 image1.v image1.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi

if [ ! -f image2.v ] || [ ! -f image2.img ]; then
  printf "\n making image2.v and image2.img\n"
  rm -f image2.i
  asc2flat image2.dat image2.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HR+ -inf=image2.inf image2.bin image2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe image2.v image2.fra
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 image2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt image2.v 2006-06-20 12:01:59
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb image2.v image2.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 image2.v image2.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi

if [ ! -f image2.i ] ; then
  printf "\n making image2.i \n"
  flat2img -scanner=HR+ -inf=image2.inf image2.bin image2.i
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe image2.i image2.fra
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 image2.i
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt image2.i 2006-06-20 12:01:59
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf "Options -little and -big \n\n"

printf "\n without options \n\n"
rm -f stdout.txt
$PROGRAM -d1 image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ana_order "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n with option -little \n\n"
rm -f stdout.txt
$PROGRAM -d1 -little image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ana_order "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n with option -big \n\n"
rm -f stdout.txt
$PROGRAM -d1 -big image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ana_order "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n=================================================================\n\n"

printf "\n 1.1.0 \n"
printf "Option -o \n\n"

printf "\n without option \n\n"
rm -f stdout.txt
$PROGRAM -d1 image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt outputdir ""
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n with option \n\n"
rm -f stdout.txt
$PROGRAM -d1 -o=newdir image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt outputdir "newdir"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n option -o= \n\n"
rm -f temp.hdr temp.img stdout.txt
cp -f image1.v temp.v
$PROGRAM -d1 -o= temp.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt outputdir "."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f temp.hdr ] ; then rm -f temp.hdr; else printf "Failed!\n" ; exit 1 ; fi
if [ -f temp.img ] ; then rm -f temp.img; else printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.1.1 \n"
printf "Check that original ECAT file is not overwritten by Analyze data \n\n"

rm -f stdout.txt temp.img temp.hdr temp2.v temp2.img temp2.hdr
cp -f image1.img temp.img
cp -f image1.v temp2.v

$PROGRAM -d1 -o= temp.img temp2.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "./temp.img would be overwritten."
if [ $? -ne 0 ] ; then 
  iftisval stdout.txt Error ".\temp.img would be overwritten."
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
printf "\n Passed. \n\n"

printf "\n check that next file was still processed ok \n\n"
if [ -f temp2.hdr ] ; then rm temp2.hdr; else printf "Failed!\n" ; exit 1 ; fi
if [ -f temp2.img ] ; then rm temp2.img; else printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"



printf "\n 1.1.2 \n"
printf "Existing Analyze data is overwritten \n\n"

rm -f temp.img temp.v stdout.txt
cp -f image1.img temp.img
cp -f image2.v temp.v
rm -f temp/* temp2/* 
rmdir temp temp2 2> nul 

$PROGRAM -o=temp -sif temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

ana2ecat -6 -o=temp2 temp/temp
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 image1.img temp2/temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

$PROGRAM -o=temp -sif temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

ana2ecat -7 -o=temp2 temp/temp
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 image2.v temp2/temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n=================================================================\n\n"


printf "\n 1.2.0 \n"
printf "Z flipping; no option or environment variable \n\n"

rm -f stdout.txt

ANALYZE_FLIP=;
export ANALYZE_FLIP
printf "\n ANALYZE_FLIP = %s\n\n", $ANALYZE_FLIP
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -d2 image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt flipping "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 1.2.1 \n"
printf "Z flipping; environment variable is y \n\n"

rm -f stdout.txt

ANALYZE_FLIP=y;
export ANALYZE_FLIP
printf "\n ANALYZE_FLIP = %s\n\n", $ANALYZE_FLIP
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -d2 image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt flipping "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 1.2.2 \n"
printf "Z flipping; environment variable is n \n\n"

rm -f stdout.txt

ANALYZE_FLIP=n;
export ANALYZE_FLIP
printf "\n ANALYZE_FLIP = %s\n\n", $ANALYZE_FLIP
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -d2 image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt flipping "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 1.2.3 \n"
printf "Z flipping; option -flip=y overrides environment variable \n\n"

rm -f stdout.txt

ANALYZE_FLIP=n;
export ANALYZE_FLIP
printf "\n ANALYZE_FLIP = %s\n\n", $ANALYZE_FLIP
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -d2 -flip=y image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt flipping "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 1.2.4 \n"
printf "Z flipping; option -flip=n overrides environment variable \n\n"

rm -f stdout.txt

ANALYZE_FLIP=y;
export ANALYZE_FLIP
printf "\n ANALYZE_FLIP = %s\n\n", $ANALYZE_FLIP
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -d2 -flip=n image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt flipping "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

# Remove environment variable
ANALYZE_FLIP=;
export ANALYZE_FLIP
printf "\n ANALYZE_FLIP = %s\n\n", $ANALYZE_FLIP



printf "\n=================================================================\n\n"


printf "\n 1.3.0 \n"
printf "Writing frames separately; no option \n\n"

rm -f stdout.txt
$PROGRAM -d2 image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt separate_frames "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 1.3.1 \n"
printf "Writing frames separately; option -frames \n\n"
rm -f stdout.txt
rm -f frames/*
rmdir frames 2> nul

$PROGRAM -d2 -frames -o=frames image2.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt separate_frames "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f frames/image2_fr001.hdr ]; then rm frames/image2_fr001.hdr ; else printf "Failed!\n"; exit 1; fi
if [ -f frames/image2_fr001.img ]; then rm frames/image2_fr001.img ; else printf "Failed!\n"; exit 1; fi
if [ -f frames/image2_fr002.hdr ]; then rm frames/image2_fr002.hdr ; else printf "Failed!\n"; exit 1; fi
if [ -f frames/image2_fr002.img ]; then rm frames/image2_fr002.img ; else printf "Failed!\n"; exit 1; fi
printf "\n Passed. \n\n"



printf "\n=================================================================\n\n"


printf "\n 1.4.0 \n"
printf "Input file: not given \n\n"

rm -f stdout.txt
$PROGRAM -d2 -frames -o=frames &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "no ECAT files were specified."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.1 \n"
printf "Input file: not exists \n\n"

rm -f stdout.txt
$PROGRAM -d2 -frames -o=frames nonexisting.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "file nonexisting.v does not exist"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.2 \n"
printf "Input file: not ECAT image \n\n"

rm -f stdout.txt
$PROGRAM -d2 image1.bin &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "unsupported file type"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

rm -f stdout.txt
$PROGRAM -d2 image1.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "unsupported file type"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.3 \n"
printf "Input file: ECAT 7 image volume ok \n\n"

rm -f stdout.txt
rm -f temp/* temp2/* 
rmdir temp temp2 2> nul
$PROGRAM -d2 -o=temp -sif image2.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
ana2ecat -7 -o=temp2 temp/image2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 image2.v temp2/image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.4 \n"
printf "Input file: ECAT 7 2D image ok \n\n"

rm -f stdout.txt
rm -f temp/* temp2/* 
rmdir temp temp2 2> nul
$PROGRAM -d2 -o=temp -sif image2.i &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
ana2ecat -7 -o=temp2 temp/image2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 image2.i temp2/image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.5 \n"
printf "Input file: ECAT 6.3 image ok \n\n"

rm -f stdout.txt
rm -f temp/* temp2/* 
rmdir temp temp2 2> nul
$PROGRAM -d2 -o=temp -sif image2.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
ana2ecat -6 -o=temp2 temp/image2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 image2.img temp2/image2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.6 \n"
printf "Input file: ECAT file contains discontinuous frame or plane numbers \n\n"

rm -f stdout.txt
rm -f temp/* temp2/* 
rmdir temp temp2 2> nul
esplit image2.img 2 3-4 temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -d2 -o=temp -sif temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

ana2ecat -6 -o=temp2 temp/temp
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=n -planes=n -abs=0.1 -rel=1 temp.img temp2/temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.7 \n"
printf "Input file: More than one ECAT files as command-line arguments \n\n"

rm -f stdout.txt
rm -f temp/* temp2/* 
rmdir temp temp2 2> nul

$PROGRAM -d2 -o=temp image1.v image2.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f temp/image1.hdr ] ; then rm temp/image1.hdr; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image1.img ] ; then rm temp/image1.img; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image2.hdr ] ; then rm temp/image2.hdr; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image2.img ] ; then rm temp/image2.img; else printf "Failed!\n"; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.8 \n"
printf "Input file: More than one ECAT files given with wildcards \n\n"

rm -f stdout.txt
rm -f temp/* temp2/* 
rmdir temp temp2  2> nul

$PROGRAM -d2 -o=temp image?.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f temp/image1.hdr ] ; then rm temp/image1.hdr; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image1.img ] ; then rm temp/image1.img; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image2.hdr ] ; then rm temp/image2.hdr; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image2.img ] ; then rm temp/image2.img; else printf "Failed!\n"; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.4.9 \n"
printf "Input file: Even when one file fails, others are processed ok \n\n"

rm -f stdout.txt
rm -f temp/* temp2/* 
rmdir temp temp2  2> nul
cp -f image2.bin temp.v

$PROGRAM -d2 -o=temp image1.v temp.v image2.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "unsupported file type"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f temp/image1.hdr ] ; then rm temp/image1.hdr; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image1.img ] ; then rm temp/image1.img; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image2.hdr ] ; then rm temp/image2.hdr; else printf "Failed!\n"; exit 1 ; fi
if [ -f temp/image2.img ] ; then rm temp/image2.img; else printf "Failed!\n"; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n=================================================================\n\n"


printf "\n 2.0.0 \n"
printf " Validation of image flipping \n\n"

printf "\n flipping \n\n"

rm -f temp/* 
rmdir temp  2> nul
$PROGRAM -o=temp -flip=y -sif image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

ana2ecat -flip=n -7 -o=temp temp/image2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgflip -z temp/image2.v temp/temp2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.1 -rel=1 image2.v temp/temp2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n no flipping \n\n"

rm -f temp/* 
rmdir temp 2> nul
$PROGRAM -o=temp -flip=n -sif image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

ana2ecat -flip=y -7 -o=temp temp/image2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgflip -z temp/image2.v temp/temp2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.1 -rel=1 image2.v temp/temp2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n=================================================================\n\n"


printf "\n 2.1.0 \n"
printf " Validation of byte order setting \n\n"

printf "\n little endian \n\n"

rm -f temp/* 
rmdir temp 2> nul
$PROGRAM -o=temp -little -sif image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

../../anabyteo -d2 -big temp/image2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
ana2ecat -7 -o=temp temp/image2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.1 -rel=1 image2.v temp/image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n=================================================================\n\n"


printf "\n 3.0.0 \n"
printf " Compatibility with previous a-lot-used software version \n\n"

rm -f temp/* temp2/*
rmdir temp temp2 2> nul

$PROGRAM -o=temp -sif ecat6.img ecat7.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n Checking Analyze headers \n"
rm -f ecat6.txt ecat7.txt
ana_lhdr temp/ecat6 > ecat6.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
ana_lhdr temp/ecat7 > ecat7.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval ecat7.txt "header_image_dimension.dim" "4 256 256 4 3 0 0 0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval ecat7.txt "header_image_dimension.datatype" "4"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval ecat6.txt "header_image_dimension.dim" "4 128 128 6 1 0 0 0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval ecat6.txt "header_image_dimension.pixdim" "0 2.34375 2.34375 4.25 0 0 0 0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n\n Checking after converting back to ECAT \n\n"
ana2ecat -6 -o=temp2 temp/ecat6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
ana2ecat -7 -o=temp2 temp/ecat7
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
ana2ecat -6 -o=temp2 prev_ecat6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
ana2ecat -7 -o=temp2 prev_ecat7
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 temp2/ecat6.img temp2/prev_ecat6.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 temp2/ecat7.v temp2/prev_ecat7.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"





if [ 0 -eq 1 ]; then
echo ===========================================================================
echo ""
echo ===========================================================================
echo "3.5.1: Validity of separate frames: can be converted back"
rm temp/* temp2/* 2> nul
rmdir temp temp2 2> nul

$PROGRAM -frames -o=temp -sif ecat7.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
# echo passed.;
# cti2sif ecat7.v temp/ecat7.sif
# if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

ana2ecat -7 temp temp2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
imgcat temp2/ecat7.v temp2/ecat7_fr???.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;

eframe ecat7.v temp2/ecat7.fra
eframe temp2/ecat7.v temp2/ecat7.fra
cp -f ecat7.v temp2/temp.v
efixplnr -frames=y temp2/temp.v

imgmatch -abs=0.1 -rel=1 temp2/ecat7.v temp2/temp.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===========================================================================
fi




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

