#!/bin/bash
#: Title      : test_e63mreg
#: Date       : 2018-03-14
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../e63mreg$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


# printf "\n verifying that required data exists \n"

printf "\n making test data \n"

if [ ! -f ecat63.img ]; then
  rm -f missed_last.img
  simcirc -format=float 32 16 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 temp.bin temp.img 1 1 32 32
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgmove temp.img -6 -2
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  # Make mask extend over 15 image planes
  imgadd -x=15 frame.img temp.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  # Use the mask image to create dynamic image
  ecatcat frame.img frame.img frame.img frame.img frame.img frames.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  ecatcat frames.img frames.img frames.img frames.img ecat63.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f missed_last.img ]; then
  e63mdel ecat63.img 20 15 missed_last.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f missed_first.img ]; then
  e63mdel ecat63.img 1 1 missed_first.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Fix image that has missing last matrix. \n"
printf " Expected result 1: Matrix appears into matrix list. \n"
printf " Expected result 2: Fixed image can be processed with normal SW. \n\n"

rm -f output.img output.txt output.ift

$PROGRAM missed_last.img output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmlist output.img > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.txt pl fr > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift sampleNr 300
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Fix image that has missing first matrix. \n"
printf " Expected result 1: Matrix appears into matrix list. \n"
printf " Expected result 2: Fixed image can be processed with normal SW. \n\n"

rm -f output.img output.txt output.ift

$PROGRAM missed_first.img output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmlist output.img > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.txt pl fr > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift sampleNr 300
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


