#!/bin/bash
#: Title      : test_e7to63
#: Date       : 2016-11-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../e7to63$EXT;
DATAPATH=../ECAT931
PROGRAM2=../../e63to7$EXT;
IMAG=$DATAPATH/s04065dy2.img
SCAN=$DATAPATH/s04065dy2.scn


printf "\n\n"
printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f $IMAG ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f $SCAN ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f mask128.img ]; then
  simboxes -format=float 128 15 32 5 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 -zoom=1.5 temp.bin mask128.img 15 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f old.tac ]; then
  img2dft $IMAG mask128.img old.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Convert ECAT 6.3 image to ECAT 7 format and back. \n"
printf " Expected result: File contents are correct. \n\n"

rm -f test.v output.tac output.img

$PROGRAM2 $IMAG test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test.v output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.img mask128.img output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=3 old.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=5 $IMAG output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Convert ECAT 6.3 sinogram to ECAT 7 format and back. \n"
printf " Expected result: File contents are correct. \n\n"

rm -f test.s output.scn

$PROGRAM2 $SCAN test.s
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test.s output.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=5 $SCAN output.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n"
printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
