#!/bin/bash
#: Title      : test_eframe
#: Date       : 2019-06-18
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../eframe$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f origdata.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi

if [ ! -f origdata2.dat ] || [ ! -f origdata2.fra ]  [ ! -f origdata2.inf ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi

if [ ! -f correct1.out ] || [ ! -f correct2.out ]  [ ! -f correct1.fra ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi

if [ ! -f original.v ] || [ ! -f original.img ]; then
  printf "\n making original.v and original.img\n"
  dft2img -zoom=2 -scanner=HR+ -dim=32 origdata.dft plane1.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc plane1.v x 2 plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd original.v plane1.v plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 original.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt original.v 2007-05-11 10:03:23
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -P original.v original.roi original.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 original.v original.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi

if [ ! -f test2.i ] ; then
  printf "\n making test2.i \n"
  asc2flat origdata2.dat test2.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HR+ -inf=origdata2.inf test2.bin test2.i
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt test2.i 2007-09-12 12:16:59
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.x.x: Use cases \n\n"

printf "\n 1.0.0 \n"
printf "  Print frame times in ECAT 6.3 image \n\n"

rm -f stdout.txt
$PROGRAM --silent original.img | tail -2 > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y correct1.out stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 1.0.1 \n"
printf "  Print frame times in ECAT 7 volume image \n\n"

rm -f stdout.txt
$PROGRAM --silent original.v | tail -2 > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y correct1.out stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 1.0.2 \n"
printf "  Print frame times in ECAT 7 2D image \n\n"

rm -f temp.i stdout.txt
cp -f test2.i temp.i
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM --silent temp.i origdata2.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --silent temp.i | tail -2 > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -x=y -y=y correct2.out stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n=================================================================\n\n"


printf "\n 1.1.0 \n"
printf "  Get info from SIF into ECAT 6 image \n\n"

rm -f temp.sif temp.bin
$PROGRAM --silent original.img temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2flat -inf=temp.inf original.img temp.bin
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
flat2img -inf=temp.inf temp.bin test.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM test.img temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch original.img test.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.1.1 \n"
printf "  Get info from SIF into ECAT 7 image \n\n"
printf "  Only empty fields will be filled \n\n"

rm -f temp.sif temp.bin test.v
$PROGRAM --silent original.v temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2flat -inf=temp.inf original.v temp.bin
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
flat2img -inf=temp.inf temp.bin test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgdecay -i=F-18 test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM test.v temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch original.v test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n\n"
imgdecay test.v > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
# program should not have overwritten isotope from SIF
iftisval stdout.txt isotope "F-18"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n=================================================================\n\n"


printf "\n 1.2.0 \n"
printf "  Copy time frames from another image into ECAT 6 image \n"
printf "  Also isotope is copied. \n\n"

rm -f temp.sif temp.bin test.img mhdr.ift lhdr.ift
$PROGRAM --silent original.img temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2flat -inf=temp.inf original.img temp.bin
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
flat2img -inf=temp.inf temp.bin test.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM test.img temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch original.img test.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

lmhdr test.img > mhdr.ift
lshdr test.img > lhdr.ift
iftisval mhdr.ift isotope_code "C-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 1.2.1 \n"
printf "  Copy time frames from another image into ECAT 7 image \n"
printf "  Also isotope is copied. \n\n"

rm -f temp.sif temp.bin test.v mhdr.ift lhdr.ift
$PROGRAM --silent original.v temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2flat -inf=temp.inf original.v temp.bin
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
flat2img -inf=temp.inf temp.bin test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM test.v temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch original.v test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

lmhdr test.v > mhdr.ift
lshdr test.v > lhdr.ift
iftisval mhdr.ift isotope_name "C-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n=================================================================\n\n"

printf "\n 2.x.x \n"
printf "\n Detailed tests \n\n"

printf "\n 2.0.0 \n"
printf "  Fail if no arguments and options \n\n"

rm -f stdout.txt
$PROGRAM  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 2.0.1 \n"
printf "  Fail if invalid option \n\n"

rm -f stdout.txt
cp -f original.v test.v
$PROGRAM -stupidoption test.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 2.0.2 \n"
printf "  Fail if extra argument \n\n"

rm -f stdout.txt
cp -f original.v test.v
$PROGRAM test.v frames.lst extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n=================================================================\n\n"

printf "\n 2.1.0 \n"
printf "  option -sec and -min \n\n"

cp -f original.v test.v

rm -f stdout.txt
$PROGRAM -d2 -sec test.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt SEC "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

rm -f stdout.txt
$PROGRAM -d2 -min test.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt SEC "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

rm -f stdout.txt
$PROGRAM -d2 test.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt SEC "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n=================================================================\n\n"

printf "\n 2.2.0 \n"
printf "  ECAT filename not given \n\n"

rm -f stdout.txt temp.sif
$PROGRAM -d2 temp.sif &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 2.2.1 \n"
printf "  ECAT file does not exist \n\n"

rm -f stdout.txt temp.sif
$PROGRAM -d2 nonexisting.v temp.sif &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "Error in reading nonexisting.v" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


rm -f stdout.txt temp.sif
$PROGRAM -d2 nonexisting.v  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "Error in reading nonexisting.v" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 2.2.2 \n"
printf "  ECAT file in wrong format \n\n"

rm -f stdout.txt
img2flat --silent original.v test.bin
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -d2 test.bin  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 2.2.3 \n"
printf "  Backup is made of original ECAT file \n\n"

rm -f stdout.txt test.v.bak temp.sif
cp -f original.v test.v
$PROGRAM test.v temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.v temp.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test.v.bak ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 2.2.4 \n"
printf "  ECAT image is not edited if operation fails \n\n"

rm -f stdout.txt test.v.bak failing.fra
echo 0 120 > failing.fra
cp -f original.v test.v

$PROGRAM test.v failing.fra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test.v ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f test.v.bak ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch original.v test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n---------------------------------------------------------------\n\n"

printf "\n 2.3.0 \n"
printf "  Frame file in wrong format \n\n"

rm -f stdout.txt test.v.bak failing.fra
echo This is not a frame time file > failing.fra
cp -f original.v test.v

$PROGRAM test.v failing.fra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test.v ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f test.v.bak ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "different frame number in failing.fra and test.v"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"



printf "\n 2.3.1 \n"
printf "  Frame time file has start times and lengths in min \n\n"

rm -f fine.fra temp.fra stdout.txt
echo 0 1 > fine.fra
echo 1 4 >> fine.fra
$PROGRAM test.v fine.fra &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

$PROGRAM -plain test.v temp.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y fine.fra temp.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 2.3.2 \n"
printf "  Frame time file has start times and lengths in sec \n\n"

rm -f fine.fra temp.fra stdout.txt
echo 0 60 > fine.fra
echo 60 240 >> fine.fra
$PROGRAM -sec test.v fine.fra &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

$PROGRAM -sec -plain test.v temp.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y fine.fra temp.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"



printf "\n 2.3.3 \n"
printf "  Frame time file has frame lengths in min \n\n"

rm -f fine.fra fine1.fra temp.fra stdout.txt
echo 1 > fine1.fra
echo 4 >> fine1.fra
echo 0 1 > fine.fra
echo 1 4 >> fine.fra
$PROGRAM test.v fine1.fra &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

$PROGRAM -plain test.v temp.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y fine.fra temp.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n 2.3.4 \n"
printf "  Frame time file has frame lengths in sec \n\n"

rm -f fine2.fra temp.fra stdout.txt
echo 60 > fine2.fra
echo 240 >> fine2.fra
echo 0 60 > fine.fra
echo 60 240 >> fine.fra
$PROGRAM -sec test.v fine2.fra &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

$PROGRAM -sec -plain test.v temp.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y fine.fra temp.fra
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n===================================================================\n"

printf "\n 3.0.0 \n"
printf "  Save ift based on filename \n\n"

rm -f output.ift

$PROGRAM original.v output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift filename original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift frame_nr 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift time_unit min
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift frame_start[1] 10.2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift frame_duration[1] 20.4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift frame_start[2] 54.9
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift frame_duration[2] 109.8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

rm -f output.ift

$PROGRAM -sec original.v output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift filename original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift frame_nr 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift time_unit sec
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift frame_start[1] 612
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift frame_duration[1] 1224
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift frame_start[2] 3294
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift frame_duration[2] 6588
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n 3.0.1 \n"
printf "  Save ift based on option \n\n"

rm -f output.txt

$PROGRAM -ift original.v output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt filename original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt frame_nr 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt time_unit min
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.txt frame_start[1] 10.2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.txt frame_duration[1] 20.4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.txt frame_start[2] 54.9
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.txt frame_duration[2] 109.8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

rm -f output.txt

$PROGRAM -ift -sec original.v output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt filename original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt frame_nr 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt time_unit sec
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt frame_start[1] 612
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt frame_duration[1] 1224
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt frame_start[2] 3294
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt frame_duration[2] 6588
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

