#!/bin/bash
#: Title      : test_fvar4img
#: Date       : 2014-09-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../fvar4img$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# Check that required files exist
if [ ! -f $PROGRAM ]; then
  printf "\nError: application file missing.\n\n"
  exit 1
fi

if [ ! -f fvar4img.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_output1.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_output2.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_sd1.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_sd2.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi

if [ ! -f dynamic.v ] || [ ! -f dynamic.img ] ; then
  rm -f dynamic.img
  printf "\n\n Creating dynamic.v \n\n"
  taccalc fvar4img.dft x 0.5 dynamic.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc fvar4img.dft x 1.5 temp.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dynamic.dft temp.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -dim=512 -zoom=1.5 dynamic.dft dynamic.v dynamic.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic.v 2012-10-31 11:09:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s dynamic.v dynamic.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi

if [ ! -f dynamic.img ] ; then
  printf "\n\n Creating dynamic.img \n\n"
  e7to63 dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi


if [ ! -f ana/dynamic.img ] || [ ! -f ana/dynamic.hdr ] ; then
  printf "\n\n Creating Analyze image \n\n"
  ecat2ana -sif -o=ana dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi


if [ ! -f nifti/dynamic.nii ] || [ ! -f nifti/dynamic.sif ] ; then
  printf "\n\n Creating NIfTI image \n\n"
  ecat2nii -sif -o=nifti dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf "\n We get correct mean activity and noise level with defaults \n\n"

rm -f stdout.txt noisy.v output.dft
$PROGRAM -efile=output.dft dynamic.v 1 noisy.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s noisy.v noisy.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# Saved Image mean and SD should be correct
tacmatch -abs=0.01 -rel=1 correct_output1.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "ROI values from noisy and noiseless images should be similar\n"
printf "Note that sometimes match is not found just because of bad luck\n"
img2dft -V=SD noisy.v dynamic.roi
tacmatch -abs=1 -rel=1 dynamic.dft noisy.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "SD in noisy image should be correct\n"
printf "Note that sometimes match is not found just because of bad luck\n"
tacmatch -abs=1 -rel=1 correct_sd1.dft noisy.sd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "=====================================================================\n"

printf "\n 1.0.1 \n"
printf "\n Same test but with higher pc \n\n"

rm -f stdout.txt noisy2.v output2.dft
$PROGRAM -efile=output2.dft dynamic.v 4 noisy2.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s noisy2.v noisy2.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# Saved Image mean and SD should be correct
tacmatch -abs=0.01 -rel=1 correct_output2.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "ROI values from noisy and noiseless images should be similar\n"
printf "Note that sometimes match is not found just because of bad luck\n"
img2dft -V=SD noisy2.v dynamic.roi
tacmatch -abs=1 -rel=5 dynamic.dft noisy2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "SD in noisy image should be correct\n"
printf "Note that sometimes match is not found just because of bad luck\n"
tacmatch -abs=1 -rel=5 correct_sd2.dft noisy2.sd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"

printf "\n 1.1.0 \n"
printf "\n ECAT 6 format \n\n"

rm -f stdout.txt noisy2.img output2.dft
$PROGRAM -efile=output2.dft dynamic.img 4 noisy2.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s noisy2.img noisy2_ecat6.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# Saved Image mean and SD should be correct
tacmatch -abs=0.01 -rel=1 correct_output2.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "ROI values from noisy and noiseless images should be similar\n"
printf "Note that sometimes match is not found just because of bad luck\n"
img2dft -V=SD noisy2.img dynamic.roi
tacmatch -abs=1 -rel=5 dynamic.dft noisy2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "SD in noisy image should be correct\n"
printf "Note that sometimes match is not found just because of bad luck\n"
tacmatch -abs=1 -rel=5 correct_sd2.dft noisy2.sd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"

printf "\n 1.2.0 \n"
printf "\n Analyze format \n\n"

rm -f stdout.txt noisy2.v output2.dft ana/noisy2.hdr ana/noisy2.img
$PROGRAM -efile=output2.dft ana/dynamic 4 ana/noisy2 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s ana/noisy2 noisy2_analyze.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# Saved Image mean and SD should be correct
tacmatch -abs=0.01 -rel=1 correct_output2.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

ana2ecat -7 ana/noisy2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "ROI values from noisy and noiseless images should be similar\n"
printf "Note that sometimes match is not found just because of bad luck\n"
img2dft -V=SD noisy2.v dynamic.roi
tacmatch -abs=1 -rel=5 dynamic.dft noisy2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "SD in noisy image should be correct\n"
printf "Note that sometimes match is not found just because of bad luck\n"
tacmatch -abs=1 -rel=5 correct_sd2.dft noisy2.sd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"

printf "\n 1.3.0 \n"
printf "\n NIfTI format \n\n"

rm -f stdout.txt noisy2.v output2.dft nifti/noisy2.nii
$PROGRAM -efile=output2.dft nifti/dynamic.nii 4 nifti/noisy2.nii &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s nifti/noisy2.nii noisy2_nifti.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# Saved Image mean and SD should be correct
tacmatch -abs=0.01 -rel=1 correct_output2.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

nii2ecat nifti/noisy2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "ROI values from noisy and noiseless images should be similar\n"
printf "Note that sometimes match is not found just because of bad luck\n"
img2dft -V=SD noisy2.v dynamic.roi
tacmatch -abs=1 -rel=5 dynamic.dft noisy2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "SD in noisy image should be correct\n"
printf "Note that sometimes match is not found just because of bad luck\n"
tacmatch -abs=1 -rel=5 correct_sd2.dft noisy2.sd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

