#!/bin/bash
#: Title      : test_imgbkgrm
#: Date       : 2018-11-15
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgbkgrm$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f plasma.tac ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f original.v ] || [ ! -f original.roi ] || [ ! -f original.dft ]; then
  rm -f noisy.v

  p2t_3c -nosub --silent plasma.tac 0.001 1.000 0 0 0 0 tmp.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr --silent orig.dft tmp.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  p2t_3c -nosub --silent plasma.tac 0.050 0.025 0 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  p2t_3c -nosub --silent plasma.tac 0.050 0.100 0 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  p2t_3c -nosub --silent plasma.tac 0.050 0.250 0 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft

  p2t_3c -nosub --silent plasma.tac 0.050 0.025 0.002 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  p2t_3c -nosub --silent plasma.tac 0.050 0.100 0.002 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  p2t_3c -nosub --silent plasma.tac 0.050 0.250 0.002 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft

  p2t_3c -nosub --silent plasma.tac 0.050 0.025 0.05 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  p2t_3c -nosub --silent plasma.tac 0.050 0.100 0.05 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  p2t_3c -nosub --silent plasma.tac 0.050 0.250 0.05 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft

  p2t_3c -nosub --silent plasma.tac 0.050 0.025 0.25 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  p2t_3c -nosub --silent plasma.tac 0.050 0.100 0.25 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  p2t_3c -nosub --silent plasma.tac 0.050 0.250 0.25 0 0 0 tmp.dft
  tacadd --silent orig.dft tmp.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f tmp.dft

  simframe --silent orig.dft frames.dat origf.dft C-11
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren --silent origf.dft 0 TAC_#
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=Advance -dim=128 -zoom=1.5 origf.dft data.v original.roi
#  dft2img -scanner=Advance -dim=8 -zoom=1.5 origf.dft data.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay --silent -i=C-11 -dc data.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd --silent original.v data.v data.v data.v data.v data.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2dft -P --silent original.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dftavg -rm --silent original.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif --silent -p=3 -rb -s original.v
fi

if [ ! -f noisy.v ]; then
  fvar4img -seed=70343861 -minsd=0.01 original.v 0.1 noisy.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif --silent -p=3 -rb -s noisy.v
fi



if [ ! -f border.v ]; then
  printf "0 0 0 0\n"    > mask01.dat
  printf "0 99 99 0\n" >> mask01.dat
  printf "0 99 99 0\n" >> mask01.dat
  printf "0 0 0 0\n"   >> mask01.dat

  printf "1 1 1 1\n"  > mask02.dat
  printf "1 4 9 1\n" >> mask02.dat
  printf "1 4 4 1\n" >> mask02.dat
  printf "1 1 1 1\n" >> mask02.dat

  printf "1 1 1 1\n"   > mask03.dat
  printf "1 0 0 1\n"  >> mask03.dat
  printf "1 0 0 1\n"  >> mask03.dat
  printf "1 1 1 13\n" >> mask03.dat

  asc2flat mask01.dat mask01.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask01.bin mask01.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  asc2flat mask02.dat mask02.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask02.bin mask02.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  asc2flat mask03.dat mask03.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask03.bin mask03.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd -x=10 frame01.v mask01.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=10 frame02.v mask02.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=10 frame03.v mask03.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgcat border.v frame01.v frame02.v frame03.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi

if [ ! -f correct_masked.v ]; then
  printf "0 0 0 0\n"  > masked.dat
  printf "0 1 1 0\n" >> masked.dat
  printf "0 1 1 0\n" >> masked.dat
  printf "0 0 0 0\n" >> masked.dat

  asc2flat masked.dat masked.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT masked.bin masked.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd -x=10 correct_masked.v masked.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi

printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Noiseless image. \n"
printf " Test case 2: Save mask image. \n"
printf " Expected result: Only pixels with low values are masked. \n\n"

rm -f mask.v output.dft
#imgthrs -mask=test.v original.v 0.01 100 
imgthrs -mask=test.v original.v 10 100 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s test.v


$PROGRAM original.v mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -p=3 -rb -s mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=no -abs=0.01 test.v mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Noiseless image. \n"
printf " Test case 2: Modify image. \n"
printf " Expected result: Image contents are changed. \n\n"

cp -f original.v test.v
rm -f output.dft

$PROGRAM test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P --silent test.v original.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftavg -rm --silent output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 original.dft output.dft
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case 1: Noisy image. \n"
printf " Test case 2: Save mask image. \n"
printf " Expected result: Higher regional TACs are close to original. \n\n"

rm -f mask.v masked.v output.dft

$PROGRAM noisy.v mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -p=3 -rb -s mask.v
imgmask noisy.v mask.v masked.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P --silent masked.v original.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftavg -rm --silent output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 1.1.0" output.svg -s original.dft -l output.dft
tacmatch -abs=3.4 -rel=1 original.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case 1: Noisy image. \n"
printf " Test case 2: Modify image. \n"
printf " Expected result 1: Image contents are changed. \n"
printf " Expected result 2: Higher regional TACs are close to original. \n\n"

cp -f noisy.v test.v
rm -f output.dft

$PROGRAM test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch original.v test.v
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P --silent test.v original.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftavg -rm --silent output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=3.4 -rel=1 original.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case: Option -keepnegat, otherwise same as before. \n"
printf " Expected result: Higher regional TACs are close to original. \n\n"

cp -f noisy.v test2.v
rm -f output2.dft

$PROGRAM -keepnegat test2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch original.v test2.v
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P --silent test2.v original.roi output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftavg -rm --silent output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 1.1.2" output2.svg -s original.dft -l output.dft output2.dft
tacmatch -abs=3.4 -rel=1 original.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Option -bordertac. \n"
printf " Test case 2: Option -bkg=border. \n"
printf " Expected result 1 : Correct border pixel means and SDs saved in TAC file. \n"
printf " Expected result 2 : Correct template is saved. \n\n"

rm -f border.tac border.ift masked.v

$PROGRAM -bordertac=border.tac -bkg=border border.v masked.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift border.tac > border.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

iftisval border.ift tacname[1] Mean
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval border.ift value[1][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval border.ift value[1][2] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval border.ift value[1][3] 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval border.ift tacname[2] SD
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval border.ift value[2][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval border.ift value[2][2] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 border.ift value[2][3] 3.330531
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

imgmatch -abs=0.001 correct_masked.v masked.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


