#!/bin/bash
#: Title      : test_imgdysmo
#: Date       : 2014-08-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgdysmo$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "Current working path is `pwd`\n"

rm -f imgdysmo_orig.tac
rm -f imgdysmo_origf.tac

p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.025 0 0 0 0 imgdysmo_orig.tac
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.100 0 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.250 0 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.025 0.002 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.100 0.002 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.250 0.002 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.025 0.05 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.100 0.05 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.250 0.05 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.025 0.25 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.100 0.25 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac
p2t_3c -nosub imgdysmo_plasma.dat 0.050 0.250 0.25 0 0 0 temp.tac
tacadd imgdysmo_orig.tac temp.tac

simframe imgdysmo_orig.tac imgdysmo_frames.dat imgdysmo_origf.tac F-18
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacren imgdysmo_origf.tac 0 @_@_#
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tac2svg -legend=y imgdysmo_origf.svg imgdysmo_origf.tac
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

# Make the test image
dft2img -SCANNER=HR+ -dim=128 -zoom=1.5 imgdysmo_origf.tac imgdysmo_tmp.v imgdysmo.roi
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
imgdecay -i=F-18 -dc imgdysmo_tmp.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
# Create image with 5 planes
imgadd imgdysmo_orig.v imgdysmo_tmp.v imgdysmo_tmp.v imgdysmo_tmp.v imgdysmo_tmp.v imgdysmo_tmp.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
# For testing compute regional values from noiseless image
img2dft -P imgdysmo_orig.v imgdysmo.roi
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
# Add noise to image
fvar4img -i=F-18 -minsd=10.0 imgdysmo_orig.v 200 imgdysmo_noisy.v
# Make TIFF images from the middle plane
img2tif -p=3 -rb imgdysmo_orig.v imgdysmo_orig.tif
img2tif -p=3 -rb imgdysmo_noisy.v imgdysmo_noisy.tif



printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n0.1.0\n"

printf "Nonexisting argument file should give an error\n"
$PROGRAM -d nonexistingfile.v smoothed.v
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.1.0\n"

printf "Binary file as argument file should not crash program\n"
$PROGRAM -d $PROGRAM smoothed.v
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "\n1.0.0\n"

printf "Filtering without added noise not change the image\n"

$PROGRAM -d -m=5 -s=2 imgdysmo_orig.v imgdysmo_smoothed_5_2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -d -m=3 -s=5 imgdysmo_orig.v imgdysmo_smoothed_3_5.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

# Compare regional values
img2dft -P imgdysmo_smoothed_5_2.v imgdysmo.roi
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
img2dft -P imgdysmo_smoothed_3_5.v imgdysmo.roi
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=0.001 imgdysmo_smoothed_5_2.dft imgdysmo_orig.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=0.02 imgdysmo_smoothed_3_5.dft imgdysmo_orig.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "\n2.0.0\n"

printf "Filtering noisy image\n"

$PROGRAM -d -m=5 -s=2 imgdysmo_noisy.v imgdysmo_smoothed_5_2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -d -m=3 -s=5 imgdysmo_noisy.v imgdysmo_smoothed_3_5.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

# Compare regional values
img2dft -P imgdysmo_smoothed_5_2.v imgdysmo.roi
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tac2svg imgdysmo_smoothed_5_2.svg -s imgdysmo_orig.dft -l imgdysmo_smoothed_5_2.dft 
img2dft -P imgdysmo_smoothed_3_5.v imgdysmo.roi
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tac2svg imgdysmo_smoothed_3_5.svg -s imgdysmo_orig.dft -l imgdysmo_smoothed_3_5.dft
dftinteg -avg imgdysmo_orig.dft 0 10 imgdysmo_orig_0-10.dft 
dftinteg -avg imgdysmo_orig.dft 10 110 imgdysmo_orig_10-120.dft 
dftinteg -avg imgdysmo_smoothed_5_2.dft 0 10 imgdysmo_smoothed_5_2_0-10.dft 
dftinteg -avg imgdysmo_smoothed_5_2.dft 10 110 imgdysmo_smoothed_5_2_10-120.dft 
tacmatch -abs=0.75 -rel=5 imgdysmo_orig_0-10.dft imgdysmo_smoothed_5_2_0-10.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=2 imgdysmo_orig_10-120.dft imgdysmo_smoothed_5_2_10-120.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
dftinteg -avg imgdysmo_smoothed_3_5.dft 0 10 imgdysmo_smoothed_3_5_0-10.dft 
dftinteg -avg imgdysmo_smoothed_3_5.dft 10 110 imgdysmo_smoothed_3_5_10-120.dft 
tacmatch -abs=0.75 -rel=5 imgdysmo_orig_0-10.dft imgdysmo_smoothed_3_5_0-10.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -abs=2 imgdysmo_orig_10-120.dft imgdysmo_smoothed_3_5_10-120.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
