#!/bin/bash
#: Title      : test_imgidpvc
#: Date       : 2019-12-08
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgidpvc$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


#printf "\n verifying that required data exists \n"
printf "\n making test data \n"

if [ ! -f 4d.v ] || [ ! -f mask3d.v ] || [ ! -f roimask3d.v ]; then
  rm -f smooth?.v
  simcirc -format=float 64 32 mask32.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simcirc -format=float 64 16 mask16.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simcirc -format=float 64  8 mask08.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT -zoom=2 mask32.bin mask32.v 1 1 64 64
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT -zoom=2 mask16.bin mask16.v 1 1 64 64
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT -zoom=2 mask08.bin mask08.v 1 1 64 64
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc mask08.v x 0 mask00.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=8 mask3d.v mask00.v mask08.v mask16.v mask32.v mask32.v mask16.v mask08.v mask00.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc mask3d.v x 80 tmp.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc tmp.v + 20 frame1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  maskinv mask3d.v mask3di.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc mask3di.v x 40 tmp.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc tmp.v + 20 frame2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  ecatcat frame1.v frame2.v 4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb 4d.v
  imgcalc mask3d.v + 1 roimask3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f smooth5.v ]; then
  imgfiltg 4d.v smooth5.v 5mm 3mm
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb smooth5.v
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Dynamic 3D ECAT7 image. \n"
printf " Test case 2: All options given. \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f output.v 

$PROGRAM -reblur=yes -alpha=1.5 -beta=1.4 -iter=30 -term=0.005 smooth5.v 11.775mm 7.065mm output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb output.v output100.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=n -abs=10 -rel=5 4d.v output.v
#if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft 4d.v roimask3d.v correct.dft
taclist -nv correct.dft
img2dft smooth5.v roimask3d.v smooth5.dft
taclist -nv smooth5.dft

img2dft output.v roimask3d.v output100.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -nv output100.dft


printf "\n 1.0.1 \n"
printf " Test case: Same but without reblurring. \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f output.v 

$PROGRAM -reblur=no -alpha=1.5 -beta=1.4 -iter=30 -term=0.005 smooth5.v 11.775mm 7.065mm output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb output.v output101.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=n -abs=10 -rel=5 4d.v output.v
#if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft 4d.v roimask3d.v correct.dft
taclist -nv correct.dft
img2dft smooth5.v roimask3d.v smooth5.dft
taclist -nv smooth5.dft

img2dft output.v roimask3d.v output101.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -nv output101.dft


printf "\n 1.1.0 \n"
printf " Test case: RL without reblurring. \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f output.v 

$PROGRAM -method=RL -reblur=n -beta=1.4 -iter=40 -term=0.0005 smooth5.v 11.775mm 7.065mm output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb output.v output110.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=n -abs=10 -rel=5 4d.v output.v
#if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft 4d.v roimask3d.v correct.dft
taclist -nv correct.dft
img2dft smooth5.v roimask3d.v smooth5.dft
taclist -nv smooth5.dft

img2dft output.v roimask3d.v output110.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -nv output110.dft

printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

