#!/bin/bash
#: Title      : test_imgssegm
#: Date       : 2019-03-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgssegm$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


#printf "\n verifying that required data exists \n"
#printf "\n making test data \n"

if [ ! -f frames.sif ]; then
  rm -f *.v i.dat
  printf "16/03/2019 09:20:15 1 4 1 test F-18\n"  > frames.sif
  printf "0 60 0 0\n" >> frames.sif
fi

if [ ! -f image2d.v ] || [ ! -f image3v.v ] || [ ! -f noisy2d.v ] || [ ! -f noisy3d.v ]; then
  rm -f *.v i.dat
  printf "0 0 0 0 3 3 3 3 6 6 6 6\n" >> i.dat
  printf "0 0 0 0 3 3 3 3 6 6 6 6\n" >> i.dat
  printf "0 0 0 0 3 3 3 3 6 6 6 6\n" >> i.dat
  printf "0 0 0 0 3 3 3 3 6 6 6 6\n" >> i.dat
  printf "1 1 1 1 4 4 4 4 7 7 7 7\n" >> i.dat
  printf "1 1 1 1 4 4 4 4 7 7 7 7\n" >> i.dat
  printf "1 1 1 1 4 4 4 4 7 7 7 7\n" >> i.dat
  printf "1 1 1 1 4 4 4 4 7 7 7 7\n" >> i.dat
  printf "2 2 2 2 5 5 5 5 8 8 8 8\n" >> i.dat
  printf "2 2 2 2 5 5 5 5 8 8 8 8\n" >> i.dat
  printf "2 2 2 2 5 5 5 5 8 8 8 8\n" >> i.dat
  printf "2 2 2 2 5 5 5 5 8 8 8 8\n" >> i.dat
  # construct 2D image
  asc2flat i.dat flat.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT flat.bin image2d.v 1 1 12 12
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s image2d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  # construct 3D image
  imgcalc image2d.v + 1 image2db.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image2d.v + 2 image2dc.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=4 image3d.v image2d.v image2db.v image2dc.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s image3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  # Add frames times and isotope from SIF
  eframe image2d.v frames.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe image3d.v frames.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  # Add a little noise
  fvar4img -minsd=0.01 -i=F-18 -seed=86017829 image2d.v 0.00001 noisy2d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  fvar4img -minsd=0.01 -i=F-18 -seed=68017829 image3d.v 0.00001 noisy3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  img2tif -rb -s noisy2d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s noisy3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Noiseless 3D image. \n"
printf " Test case 2: No options given. \n"
printf " Expected result: Output image contains correct segments. \n\n"

rm -f output.v output.tac

$PROGRAM -d9 image3d.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output.v output_100.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case 1: Noisy 3D image. \n"
printf " Test case 2: No options given. \n"
printf " Expected result: Output image contains correct segments. \n\n"

rm -f output2.v

$PROGRAM -d9 noisy3d.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output2.v output_101.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

