/** @file pbconv.h
 *  @brief Header file for pbconv.c
 *  @copyright (c) Turku PET Centre
 *  @author Vesa Oikonen
 */
/*****************************************************************************/
#ifndef _PBCONV_H
#define _PBCONV_H
/*****************************************************************************/
/** Codes for PET tracers */ 
typedef enum {NORBC,INWATER,FDG,FLUORIDE,FBPA,FDOPA,MEAIB,PIB,FLUMAZENIL,
              AH690,AH691,FMPEPD2,
              PALMITATE,PK11195,PE2I,CARFENTANIL,METOMIDATE,ORMB,
              PBR28HAB,PBR28MAB,PBR28LAB,SMW139,
              MOUSEFDG1,MOUSEFDG2,RATFDG
             } tracerCode;
/*****************************************************************************/
int tracer_code(char *tracer);
int rbc_plasma_ratio(int tracer, double *t, double *r, int nr);
int plasma_to_blood_ratio(int tracer, double *t, double *r, int nr);
/*****************************************************************************/
#endif // _PBCONV_H

