#!/bin/bash
#: Title      : test_absscal
#: Date       : 2018-04-27
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../absscal$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "=====================================================================\n"
printf "verifying that required data exists for testing %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f pump_cal2.dat ] || [ ! -f pump_cal4.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f t00001_blo.lis ] || [ ! -f t2.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f correct_pump1.kbq ] || [ ! -f correct_pump2.kbq ] || [ ! -f correct_pump2b.csv ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f correct_pump3.kbq ] || [ ! -f correct_pump4.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f t00061.alg ] || [ ! -f ME_ABSS09282_is731dy1.txt ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f ME_ABSS09282_is731dy1_nobkg.txt ] || [ ! -f ME_ABSS09282_is731dy1_zerobkg.txt ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f t00061bkg2.alg ] || [ ! -f t00061nobkg.alg ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f t00061nobkgdate.alg ] || [ ! -f t00061zerobkg.alg ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f t00061bkg2.alg ] || [ ! -f t2wotime.bld ] || [ ! -f ch_0.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"
if [ ! -f tf04042018_2.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf " ok \n"


printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n\n1.1.1: checking measurement_start_time...\n\n"

printf "\n ... with pump 1\n\n"
rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=O t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat measurement_start_time "1989-11-30 11:19:17"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2; time is taken from sample times if not in titles\n\n"
rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat -i=O -decay=on t2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -c=pump_cal2.dat -i=O-15 -decay=on t2wotime.bld test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat measurement_start_time "2001-02-23 11:17:26"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test2.dat measurement_start_time "2001-02-23 11:17:26"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 3\n\n"
rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=C t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat measurement_start_time "2005-05-11 11:29:33"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"
rm -f test1.dat
$PROGRAM -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat measurement_start_time "2010-05-17 12:31:37"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "=====================================================================\n"

printf "\n\n1.1.2: checking time_unit \n\n"

printf "\n ... with pump 1\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat -i=O t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -min -c=pump_cal2.dat -i=O t00001_blo.lis test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

iftisval test1.dat time_unit "sec"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test2.dat time_unit "min"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -sec -c=pump_cal2.dat -i=O t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat time_unit "sec"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat t2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -min -c=pump_cal2.dat t2.bld test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

iftisval test1.dat time_unit "sec"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test2.dat time_unit "min"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n ... with pump 3\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat -i=C t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -min -c=pump_cal2.dat -i=C t00061.alg test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

iftisval test1.dat time_unit "sec"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test2.dat time_unit "min"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -min -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

iftisval test1.dat time_unit "sec"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test2.dat time_unit "min"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n===================================================================\n"

printf "\n\n1.1.3-4: checking calibrated and unit \n\n"

printf "\n ... with pump 1\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat -i=O t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -i=O t00001_blo.lis test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibrated "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat calibrated "no"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat unit "kBq/ml"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat unit "cps"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat t2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -i=O-15 t2.bld test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibrated "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat calibrated "no"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat unit "kBq/ml"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat unit "cps"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 3\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat -i=C-11 t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -i=C t00061.alg test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibrated "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat calibrated "no"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat unit "kBq/ml"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat unit "cps"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM ME_ABSS09282_is731dy1.txt test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibrated "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat calibrated "no"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat unit "kBq/ml"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat unit "cps"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"

printf "\n\n1.1.5-8: \n"
printf "    calibration_date, pump_calibration_factor, \n"
printf "    wc_calibration_factor_per_br, and calibration_file \n"

printf "\n ... with pump 1\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat -i=O t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibration_date "1900-01-01"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat pump_calibration_factor "51"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat wc_calibration_factor_per_br "0.0027027"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibration_file "pump_cal2.dat"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat -i=O-15 t2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibration_date "2001-02-02"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat pump_calibration_factor "41.6"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval -abs=0.000001 test1.dat wc_calibration_factor_per_br "0.00288288"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibration_file "pump_cal2.dat"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 3\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat -i=C-11 t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibration_date "2004-09-29"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat pump_calibration_factor "14"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat wc_calibration_factor_per_br "0.00278557"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibration_file "pump_cal2.dat"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat test2.dat
$PROGRAM -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibration_date "2010-01-20"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat pump_calibration_factor "12.7"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat wc_calibration_factor_per_br "0.00278278"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat calibration_file "pump_cal2.dat"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"

printf "\n\n1.1.9: isotope \n"

printf "\n ... with pump 1\n\n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=O-15 t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "O-15"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=C-11 t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "C-11"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=F-18 t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "F-18"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2\n\n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=O-15 t2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "O-15"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

rm -f test1.dat stdout.txt
$PROGRAM -c=pump_cal2.dat -i=C-11 t2.bld test1.dat &> stdout.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt Error "different isotope in file and given by user."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with new format of pump 2\n\n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=F-18 tf04042018_2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "F-18"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

rm -f test1.dat stdout.txt
$PROGRAM -c=pump_cal2.dat -i=C-11 tf04042018_2.bld test1.dat &> stdout.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt Error "different isotope in file and given by user."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n ... with pump 3\n\n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=O-15 t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "O-15"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=C-11 t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "C-11"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=F-18 t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "F-18"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"
printf "Pump 4 data contains isotope but command-line option must override it\n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=O-15 ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "O-15"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=C-11 ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "C-11"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=F-18 ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat isotope "F-18"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"

printf "\n\n1.1.10: decay correction \n"

printf "\n ... with pump 1\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM            -i=O-15 t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -decay=off -i=O-15 t00001_blo.lis test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -decay=on  -i=O-15 t00001_blo.lis test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat decay_correction "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat decay_correction "no"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat decay_correction "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM            t2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -decay=off t2.bld test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -decay=on  t2.bld test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat decay_correction "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat decay_correction "no"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat decay_correction "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 3\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM            -i=F-18 t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -decay=off -i=F-18 t00061.alg test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -decay=on  -i=F-18 t00061.alg test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat decay_correction "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat decay_correction "no"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat decay_correction "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM            -i=O-15 ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -decay=off -i=O-15 ME_ABSS09282_is731dy1.txt test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -decay=on  -i=O-15 ME_ABSS09282_is731dy1.txt test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat decay_correction "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat decay_correction "no"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat decay_correction "yes"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"



printf "\n===================================================================\n"

printf "\n\n1.1.11: injection_time \n"

printf "\n ... with pump 1\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -start=0   -i=O -c=pump_cal2.dat t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=10  -i=O -c=pump_cal2.dat t00001_blo.lis test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=-10 -i=O -c=pump_cal2.dat t00001_blo.lis test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat injection_time "1989-11-30 11:19:17"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat injection_time "1989-11-30 11:19:07"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat injection_time "1989-11-30 11:19:27"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -start=0   -c=pump_cal2.dat t2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=60  -c=pump_cal2.dat t2.bld test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=-60 -c=pump_cal2.dat t2.bld test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat injection_time "2001-02-23 11:17:26"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat injection_time "2001-02-23 11:16:26"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat injection_time "2001-02-23 11:18:26"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with new format of pump 2\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -start=0   -c=pump_cal2.dat tf04042018_2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=60  -c=pump_cal2.dat tf04042018_2.bld test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=-60 -c=pump_cal2.dat tf04042018_2.bld test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat injection_time "2018-04-04 11:31:33"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat injection_time "2018-04-04 11:30:33"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat injection_time "2018-04-04 11:32:33"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 3\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -start=0   -i=C -c=pump_cal2.dat t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=30  -i=C -c=pump_cal2.dat t00061.alg test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=-30 -i=C -c=pump_cal2.dat t00061.alg test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat injection_time "2005-05-11 11:29:33"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat injection_time "2005-05-11 11:29:03"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat injection_time "2005-05-11 11:30:03"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -start=0   -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=30  -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -start=-30 -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat injection_time "2010-05-17 12:31:37"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat injection_time "2010-05-17 12:31:07"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat injection_time "2010-05-17 12:32:07"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"



printf "\n===================================================================\n"

printf "\n\n1.1.12-13: background_date and background \n"

printf "\n ... with pump 3\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -i=C -c=pump_cal2.dat t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -i=C -c=pump_cal2.dat t00061bkg2.alg test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -i=C -c=pump_cal2.dat t00061nobkgdate.alg test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat background_date "2005-05-11"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat background_date "2005-05-11"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat background "3.6 [cps]"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test2.dat background "3.6 [cps]"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test3.dat background "3.6 [cps]"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat
$PROGRAM -i=C -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.dat background_date "2010-02-03"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval test1.dat background "2.9 [cps]"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"



printf "\n===================================================================\n"

printf "\n\n2.0.0: sample times with negative start time \n"

printf "\n ... with pump 1\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -c=pump_cal2.dat -i=O -start=-10 t00001_blo.lis test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -c=pump_cal2.dat -i=O            t00001_blo.lis test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tactime test2.dat -10 test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -x=y -y=n -abs=0.001 -rel=0.1 test1.dat test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -c=pump_cal2.dat -start=-10 t2.bld test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -c=pump_cal2.dat            t2.bld test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tactime test2.dat -10 test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -x=y -y=n -abs=0.001 -rel=0.1 test1.dat test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 3\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -c=pump_cal2.dat -i=C -start=-10 t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -c=pump_cal2.dat -i=C            t00061.alg test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tactime test2.dat -10 test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -x=y -y=n -abs=0.001 -rel=0.1 test1.dat test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -c=pump_cal2.dat -start=-10 ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -c=pump_cal2.dat            ME_ABSS09282_is731dy1.txt test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tactime test2.dat -10 test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -x=y -y=n -abs=0.001 -rel=0.1 test1.dat test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n\n2.1.0: sample times with positive start time \n"


printf "\n ... with pump 3\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -c=pump_cal2.dat -i=C -start=+20 t00061.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -c=pump_cal2.dat -i=C            t00061.alg test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tactime test2.dat +20 test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -x=y -y=n -abs=0.001 -rel=0.1 test1.dat test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat test2.dat test3.dat
$PROGRAM -c=pump_cal2.dat -start=+20 ME_ABSS09282_is731dy1.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -c=pump_cal2.dat            ME_ABSS09282_is731dy1.txt test2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tactime test2.dat +20 test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacmatch -x=y -y=n -abs=0.001 -rel=0.1 test1.dat test3.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"



printf "\n===================================================================\n"

printf "\n\n2.2.0: corrupted data (channel 2 contains only 0) \n"
printf "\n   should return error \n"

printf "\n ... with pump 2\n\n"

rm -f test1.dat stdout.txt
$PROGRAM -c=pump_cal2.dat ch_0.bld test1.dat &> stdout.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "All values from channel 1 are zeros. Contact the physicist!"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"

printf "\n\n4.1.0: Missing Allogg background must lead to an error \n"

printf "\n ... with pump 3\n\n"

rm -f test1.dat stdout.txt
$PROGRAM -c=pump_cal2.dat -i=C t00061nobkg.alg test1.dat &> stdout.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "t00061nobkg.alg does not contain background."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat stdout.txt
$PROGRAM -c=pump_cal2.dat -i=C ME_ABSS09282_is731dy1_nobkg.txt test1.dat &> stdout.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "ME_ABSS09282_is731dy1_nobkg.txt does not contain background."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n\n4.2.0: Allogg background zero is ok \n"

printf "\n ... with pump 3\n\n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=C t00061zerobkg.alg test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f test1.dat
$PROGRAM -c=pump_cal2.dat -i=C ME_ABSS09282_is731dy1_zerobkg.txt test1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"

printf "\n\n5.1.1-4: Correct results with typical settings \n"

printf "\n ... with pump 1\n\n"

rm -f pump1.dat
$PROGRAM -c=pump_cal2.dat -i=O t00001_blo.lis pump1.kbq
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.01 -rel=0.5 correct_pump1.kbq pump1.kbq
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 2\n\n"

rm -f pump2.dat
$PROGRAM -c=pump_cal2.dat t2.bld pump2.kbq
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.01 -rel=0.5 correct_pump2.kbq pump2.kbq
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with new format of pump 2\n\n"

rm -f pump2b.dat
$PROGRAM -c=pump_cal4.dat tf04042018_2.bld pump2b.tac
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.01 -rel=0.5 correct_pump2b.csv pump2b.tac
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 3\n\n"

rm -f pump3.dat
$PROGRAM -c=pump_cal2.dat -i=C t00061.alg pump3.kbq
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.01 -rel=0.5 correct_pump3.kbq pump3.kbq
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

printf "\n ... with pump 4\n\n"

rm -f pump4.dat
$PROGRAM -c=pump_cal2.dat ME_ABSS09282_is731dy1.txt pump4.kbq
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.01 -rel=0.5 correct_pump4.kbq pump4.kbq
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"
printf "  All passed.\n"
printf "===================================================================\n"
exit 0
