#!/bin/bash
#: Title      : test_fit_o2bl
#: Date       : 2016-02-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../fit_o2bl$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f test1234_blo.kbq ] || [ ! -f test1234wb.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_output100.res ] || [ ! -f correct_output110.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Normal usage with default settings. \n"
printf " Expected result: Reasonable fit. \n\n"

rm -f output100.res
$PROGRAM -svg=test100.svg test1234_blo.kbq test1234wb.bld output100.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parunits=y -abs=1.0E-6 -rel=1 correct_output100.res output100.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Normal usage with k4 model. \n"
printf " Expected result: Same result as without setting model. \n\n"

rm -f output.res
$PROGRAM -model=k4 test1234_blo.kbq test1234wb.bld output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parunits=y -abs=1.0E-8 -rel=0.1 output100.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Normal usage with k3 model. \n"
printf " Expected result: Reasonable fit. \n\n"

rm -f output110.res
$PROGRAM -model=k3 -svg=test110.svg test1234_blo.kbq test1234wb.bld output110.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parunits=y -abs=1.0E-6 -rel=1 correct_output110.res output110.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Result filename extension is .ift. \n"
printf " Expected result: Correct results are saved in IFT format. \n\n"

rm -f output120.ift
parformat -f=ift correct_output100.res temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM test1234_blo.kbq test1234wb.bld output120.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=1.0E-5 temp.ift output120.ift k1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=1.0E-5 temp.ift output120.ift k3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=1.0E-2 temp.ift output120.ift k3/k4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch -abs=0.5 temp.ift output120.ift delay
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: delay and k3/k4 fixed. \n"
printf " Expected result: fixed parameters in results are correct. \n\n"

rm -f output.ift
$PROGRAM -delay=6.0 -k3k4=1.0 -model=k4 test1234_blo.kbq test1234wb.bld output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift delay "6 sec"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift k3/k4 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case: delay and k3 fixed. \n"
printf " Expected result: fixed parameters in results are correct. \n\n"

rm -f output.ift
$PROGRAM -delay=6.0 -k3=0.003 -model=k4 test1234_blo.kbq test1234wb.bld output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift delay "6 sec"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift k3 "0.003 1/sec"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n\n"
printf "=====================================================================\n"
printf "error testing for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt
$PROGRAM -stupidoption test1234_blo.kbq test1234wb.bld output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument entered. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt
$PROGRAM test1234_blo.kbq test1234wb.bld output.res extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "too many arguments: 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Missing argument(s). \n"
printf " Expected result: Error. \n"

rm -f stdout.txt
$PROGRAM test1234_blo.kbq test1234wb.bld &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt
$PROGRAM nonexistingfile.dat test1234wb.bld output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexistingfile.dat'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.1 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt
$PROGRAM test1234_blo.kbq nonexistingfile.dat output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexistingfile.dat'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




rm -f *.bak
printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0
