#!/bin/bash
#: Title      : test_mask2pxl
#: Date       : 2017-08-30
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../mask2pxl$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n making test data \n"


if [ ! -f mask.dat ] || [ ! -f mask.v ]; then
rm -f mask.bin mask.v
printf "0 1 0 0\n"  > mask.dat
printf "1 0 3 0\n" >> mask.dat
printf "0 0 2 0\n" >> mask.dat
printf "0 -1 0 1\n" >> mask.dat
fi

if [ ! -f mask.bin ] || [ ! -f mask.v ]; then
  asc2flat mask.dat mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask.bin mask.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=3 mask3d.v mask.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_mask.dat ]; then
printf "2,1,1,0\n"  > correct_mask.dat
printf "1,2,1,0\n" >> correct_mask.dat
printf "3,2,1,0\n" >> correct_mask.dat
printf "3,3,1,0\n" >> correct_mask.dat
printf "2,4,1,0\n" >> correct_mask.dat
printf "4,4,1,0\n" >> correct_mask.dat
fi

if [ ! -f correct_mask3d.dat ]; then
printf "2,1,1,0\n"  > correct_mask3d.dat
printf "1,2,1,0\n" >> correct_mask3d.dat
printf "3,2,1,0\n" >> correct_mask3d.dat
printf "3,3,1,0\n" >> correct_mask3d.dat
printf "2,4,1,0\n" >> correct_mask3d.dat
printf "4,4,1,0\n" >> correct_mask3d.dat
printf "2,1,2,0\n" >> correct_mask3d.dat
printf "1,2,2,0\n" >> correct_mask3d.dat
printf "3,2,2,0\n" >> correct_mask3d.dat
printf "3,3,2,0\n" >> correct_mask3d.dat
printf "2,4,2,0\n" >> correct_mask3d.dat
printf "4,4,2,0\n" >> correct_mask3d.dat
printf "2,1,3,0\n" >> correct_mask3d.dat
printf "1,2,3,0\n" >> correct_mask3d.dat
printf "3,2,3,0\n" >> correct_mask3d.dat
printf "3,3,3,0\n" >> correct_mask3d.dat
printf "2,4,3,0\n" >> correct_mask3d.dat
printf "4,4,3,0\n" >> correct_mask3d.dat
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case: 2D mask list into file. \n"
printf " Expected result: Correct list. \n\n"

rm -f output.dat

$PROGRAM mask.v output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_mask.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.0 \n"
printf " Test case: 3D mask list into file. \n"
printf " Expected result: Correct list. \n\n"

rm -f output3d.dat

$PROGRAM mask3d.v output3d.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_mask3d.dat output3d.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


