#!/bin/bash
#: Title      : test_maskconj
#: Date       : 2017-08-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../maskconj$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n making test data \n"


if [ ! -f mask1.dat ] || [ ! -f mask1.v ]; then
rm -f mask1.bin mask1.v
printf "0 1 0 0\n"  > mask1.dat
printf "1 0 3 0\n" >> mask1.dat
printf "0 0 2 0\n" >> mask1.dat
printf "0 -1 0 1\n" >> mask1.dat
fi

if [ ! -f mask1.bin ] || [ ! -f mask1.v ]; then
  asc2flat mask1.dat mask1.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask1.bin mask1.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f mask2.dat ] || [ ! -f mask2.v ]; then
rm -f mask2.bin mask2.v
printf "1 1 0 1\n"  > mask2.dat
printf "1 0 0 0\n" >> mask2.dat
printf "0 1 1 0\n" >> mask2.dat
printf "0 1 0 1\n" >> mask2.dat
fi

if [ ! -f mask2.bin ] || [ ! -f mask2.v ]; then
  asc2flat mask2.dat mask2.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask2.bin mask2.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f maskc.dat ] || [ ! -f maskc.v ]; then
rm -f maskc.bin maskc.v
printf "0 1 0 0\n"  > maskc.dat
printf "1 0 0 0\n" >> maskc.dat
printf "0 0 1 0\n" >> maskc.dat
printf "0 1 0 1\n" >> maskc.dat
fi

if [ ! -f maskc.bin ] || [ ! -f maskc.v ]; then
  asc2flat maskc.dat maskc.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT maskc.bin maskc.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb maskc.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case: Conjuction of the mask with itself. \n"
printf " Expected result: Result mask is same as original. \n\n"

rm -f output.v

$PROGRAM mask2.v mask2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 mask2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Conjuction of two different masks. \n"
printf " Expected result: Correct mask image. \n\n"

rm -f output.v

$PROGRAM mask1.v mask2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_1_0_1.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 maskc.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


