#!/bin/bash
#: Title      : test_maskdila
#: Date       : 2019-11-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../maskdila$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


# printf "\n verifying that required data exists \n"


printf "\n making test data \n"


if [ ! -f mask.dat ] || [ ! -f mask.v ]; then
rm -f mask.bin mask.v
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
fi

if [ ! -f mask.bin ] || [ ! -f mask.v ]; then
  asc2flat mask.dat mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask.bin mask.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_cube.dat ] || [ ! -f correct_cube.v ]; then
rm -f correct_cube.bin correct_cube.v
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > correct_cube.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
printf "2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
printf "2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_cube.dat
fi

if [ ! -f correct_cube.bin ] || [ ! -f correct_cube.v ]; then
  asc2flat correct_cube.dat correct_cube.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT correct_cube.bin correct_cube.v 1 1 16 16 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct_cube.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_star.dat ] || [ ! -f correct_star.v ]; then
rm -f correct_star.bin correct_star.v
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > correct_star.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
printf "2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
printf "2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_star.dat
fi

if [ ! -f correct_star.bin ] || [ ! -f correct_star.v ]; then
  asc2flat correct_star.dat correct_star.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT correct_star.bin correct_star.v 1 1 16 16 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct_star.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n make 3D test data\n"

if [ ! -f mask3d.v ]; then
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p1.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p2.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p3.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd mask3d.v p1.v p1.v p1.v p2.v p3.v p1.v p1.v p1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct3d_cube.bin ] || [ ! -f correct3d_rcube.v ] || [ ! -f correct3d_star.v ]; then

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p1.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 2 2 2 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 2 2 2 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 2 2 2 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p2a.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p3a.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd correct3d_cube.v p1.v p1.v p2a.v p2a.v p2a.v p3a.v p1.v p1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct3d_cube.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi


  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 2 2 2 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p2b.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p3b.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 2 2 2 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p3c.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd correct3d_rcube.v p1.v p1.v p2b.v p2a.v p3c.v p3b.v p1.v p1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct3d_rcube.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p2c.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 3 3 3 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p3d.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p2d.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd correct3d_star.v p1.v p1.v p2c.v p2b.v p3d.v p2d.v p1.v p1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct3d_star.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: No options, giving name for output file. \n"
printf " Test case 2: Single matrix of mask image. \n"
printf " Expected result: Correctly dilated. \n\n"

rm -f output.v
$PROGRAM mask.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_1_0_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 correct_cube.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Same but overwriting input image. \n"
printf " Expected result: Correctly dilated. \n\n"

cp -f mask.v output.v
$PROGRAM output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 correct_cube.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 1.1.0 \n"
printf " Test case 1: Option to use cube. \n"
printf " Test case 2: Single matrix of mask image. \n"
printf " Expected result: Correctly dilated. \n\n"

cp -f mask.v output.v
$PROGRAM -struct=cube output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_1_1_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 correct_cube.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Option to use rounded cube. \n"
printf " Test case 2: Single matrix of mask image. \n"
printf " Notice: in 2D matrix star equals the cube. \n"
printf " Expected result: Correctly dilated. \n\n"

cp -f mask.v output.v
$PROGRAM -struct=rcube output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_1_2_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 correct_cube.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case 1: Option to use star. \n"
printf " Test case 2: Single matrix of mask image. \n"
printf " Notice: in 2D matrix star equals the cube. \n"
printf " Expected result: Correctly dilated. \n\n"

cp -f mask.v output.v
$PROGRAM -struct=star output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_1_3_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 correct_star.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n------------------------------------------------\n"

printf "\n 2.0.0 \n"
printf " Test case 1: 3D matrix. \n"
printf " Test case 2: Dilating with cube. \n"
printf " Expected result: Correctly dilated. \n\n"

cp -f mask3d.v output.v
$PROGRAM -struct=cube output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_2_0_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 correct3d_cube.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case 1: 3D matrix. \n"
printf " Test case 2: Dilating with rcube. \n"
printf " Expected result: Correctly dilated. \n\n"

cp -f mask3d.v output.v
$PROGRAM -struct=rcube output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_2_1_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 correct3d_rcube.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.0 \n"
printf " Test case 1: 3D matrix. \n"
printf " Test case 2: Dilating with star. \n"
printf " Expected result: Correctly dilated. \n\n"

cp -f mask3d.v output.v
$PROGRAM -struct=star output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_2_2_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 correct3d_star.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


