#!/bin/bash
#: Title      : test_maskinv
#: Date       : 2017-08-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../maskinv$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n making test data \n"


if [ ! -f mask.dat ] || [ ! -f mask.v ]; then
rm -f mask.bin mask.v
printf "0 1 0 0\n"  > mask.dat
printf "1 0 3 0\n" >> mask.dat
printf "0 0 2 0\n" >> mask.dat
printf "0 -1 0 1\n" >> mask.dat
fi

if [ ! -f mask.bin ] || [ ! -f mask.v ]; then
  asc2flat mask.dat mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask.bin mask.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f maski.dat ] || [ ! -f maski.v ]; then
rm -f maski.bin maski.v
printf "1 0 1 1\n"  > maski.dat
printf "0 1 0 1\n" >> maski.dat
printf "1 1 0 1\n" >> maski.dat
printf "1 0 1 0\n" >> maski.dat
fi

if [ ! -f maski.bin ] || [ ! -f maski.v ]; then
  asc2flat maski.dat maski.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT maski.bin maski.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb maski.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case: Normal mask inversion. \n"
printf " Expected result: Correctly inverted. \n\n"

rm -f output.v

$PROGRAM mask.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_1_0_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 maski.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


