#!/bin/bash
#: Title      : test_masksize
#: Date       : 2018-02-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../masksize$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


printf "\n make 3D test data\n"

if [ ! -f mask3d.v ] || [ ! -f mask3d.img ]; then

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p1.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p2.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p3.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd mask3d.v p1.v p1.v p1.v p2.v p3.v p1.v p1.v p1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  e7to63 mask3d.v mask3d.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case: List labels in 3D matrix in ECAT 7 format. \n"
printf " Expected result: Correct labels and sizes reported. \n\n"

rm -f stdout.txt

$PROGRAM mask3d.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt xdim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ydim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt zdim 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt label_1 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_2 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_3 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt totalNr 11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt largestRegion 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt largestSize 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Sort labels in 3D matrix in ECAT 7 format. \n"
printf " Expected result: Correct relabelling done to the mask file. \n\n"

cp -f mask3d.v test.v
rm -f stdout.txt

$PROGRAM -sort test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt xdim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ydim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt zdim 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt label_1 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_2 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_3 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt totalNr 11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt largestRegion 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt largestSize 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Sort labels in 3D matrix in ECAT 6 format. \n"
printf " Expected result: Correct relabelling done to the mask file. \n\n"

cp -f mask3d.img test.img
rm -f stdout.txt

$PROGRAM -sort test.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt xdim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ydim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt zdim 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt label_1 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_2 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_3 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt totalNr 11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt largestRegion 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt largestSize 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case: Sort labels in 3D matrix in NIfTI format. \n"
printf " Expected result: Correct relabelling done to the mask file. \n\n"


rm -f nifti/* 
rmdir nifti
ecat2nii -sif -o=nifti mask3d.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f stdout.txt

$PROGRAM -sort nifti/mask3d.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM nifti/mask3d.nii &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt xdim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ydim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt zdim 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt label_1 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_2 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_3 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt totalNr 11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt largestRegion 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt largestSize 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.3 \n"
printf " Test case: Sort labels in 3D matrix in Analyze format. \n"
printf " Expected result: Correct relabelling done to the mask file. \n\n"


rm -f anal/* 
rmdir anal
ecat2nii -sif -o=anal mask3d.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f stdout.txt

$PROGRAM -sort anal/mask3d
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM anal/mask3d &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt xdim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ydim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt zdim 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt label_1 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_2 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_3 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt totalNr 11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt largestRegion 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt largestSize 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Application works with masklbl. \n"
printf " Expected result: Correct relabelling done to the mask file. \n\n"

cp -f mask3d.v test.v
rm -f stdout.txt

masklbl test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -sort test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt xdim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt ydim 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt zdim 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt label_1 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_2 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt label_3 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt totalNr 11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt largestRegion 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt largestSize 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


