#!/bin/bash
#: Title      : test_imgki_big
#: Date       : 2021-11-15
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgki$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f plasma.dat ] || [ ! -f frames.dat ] || [ ! -f simulation.par ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_ki_huge.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "\n making test data \n"

if [ ! -f dynamic.tac ]; then
  sim_3tcm simulation.par plasma.dat plasma.dat dynamic.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe dynamic.dat frames.dat dynamic.tac F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n\n"
fi

printf "\n making huge image data \n"
if [ ! -f huge.nii ]; then
  tac2nii dynamic.tac 512 512 256 huge hugetemplate
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n\n"
fi

if [ ! -f correct_ki_huge.nii ]; then
  tac2nii correct_ki_huge.tac 512 512 256 correct_ki_huge
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n\n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Huge NIfTI 1S file. \n"
printf " Expected result: Correct Ki calculated. \n\n"

rm -f output.*

$PROGRAM plasma.dat huge 30 output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.005 -rel=1 correct_ki_huge output 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output hugetemplate output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -abs=0.005 -rel=1 correct_ki_huge.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.*



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"

rm -f huge.* hugetemplate.* correct_ki_huge.nii correct_ki_huge.sif

exit 0
