#!/bin/bash
#: Title      : test_nii2ecat
#: Date       : 2014-10-07
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../nii2ecat$EXT;
echo ""
echo ===============================================================================
echo "testing "$PROGRAM
echo ===============================================================================
echo ""
if [ -e "$PROGRAM" ] ; then
echo "Available executable "$PROGRAM
else
echo "Failed: Missing executable "$PROGRAM
exit 1
fi


if [ -f image2.v ]; then
echo "Test data seems to exist, thus not created now."
else 
echo ===============================================================================
echo "creating test data"
echo ===============================================================================
echo ""

asc2flat image2.dat image2.bin
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
flat2img -scanner=HR+ -inf=image2.inf image2.bin image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
eframe image2.v image2.fra
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
imgdecay -i=F-18 image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
esetstrt image2.v 2013-03-26 13:20:59
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
img2tif -rb -s image2.v image2.tif
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi


fi

echo ===============================================================================
echo "Creating NIfTI image for testing"
echo ===============================================================================
rm -f single/* dual/* 2> nul
rmdir single dual 2> nul
echo passed. ; echo ""
ecat2nii -sif -o=single image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
ecat2nii -sif -dual -o=dual image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi


echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.1.1: No command line options or arguments. Error with user info."
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM &> stdout.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt "Keywords"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.1.2: Unknown option."
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -stupidoption single/image2.nii 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "invalid option '-stupidoption'"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.1.3: Extra argument."
echo "       NOT APPLICABLE"
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.2.1: option -h print user info"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -h > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt "Keywords"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.2.2: option --help print user info"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM --help > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt "Keywords"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.7.1: option -o; without it"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -d2 single/image2.nii > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt ecatdir "."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.7.2: option -o; with it"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -d2 -o=newdir single/image2.nii > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt ecatdir "newdir"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
if [ -f newdir/image2.v ] ; then rm newdir/image2.v; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "2.1.1: Input file name not given"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -d2 -o=temp 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "NIfTI image was not given."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.2.1: non-existing input file"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -d2 nonexisting.nii 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "cannot open NIfTI image or directory nonexisting.nii (file not accessible)"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.3.1: format not NIfTI"
if [ -f wrong.nii ] ; then rm wrong.nii ; fi
cp -f image2.bin wrong.nii
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -d2 wrong.nii 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
iftisval stderr.txt Error "cannot open NIfTI image or directory wrong.nii (file is not Nifti)"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.; echo ""

if [ -f wrong.nii ] ; then rm wrong.nii ; fi
cp -f image2.dat wrong.nii
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -d2 wrong.nii 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
iftisval stderr.txt Error "cannot open NIfTI image or directory wrong.nii (file is not Nifti)"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.; echo ""
echo ===============================================================================
echo "2.3.2: Single file format: ok"
rm -f temp/* 2> nul
rmdir temp 2> nul
$PROGRAM -d2 -o=temp single/image2.nii 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
imgmatch -abs=0.1 -rel=1 image2.v temp/image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.3.3: Dual file format: ok"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
rm -f temp2/* 2> nul
rmdir temp2 2> nul
$PROGRAM -d2 -o=temp2 dual/image2 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
imgmatch -abs=0.1 -rel=1 image2.v temp2/image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""


#exit 0
echo ""
echo ===============================================================================
echo ""
echo "All passed!"
echo ""
echo ===============================================================================
exit 0
