#!/bin/bash
#: Title      : test_res2html
#: Date       : 2015-08-28
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../res2html$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f test.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 0.1.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.res 
$PROGRAM -stupidoption test.res bluf &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   General tests \n"
printf "===================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: save result file contents in HTML table file. \n"
printf " Test case 2: output filename is not given by user. \n"
printf " Expected result: HTML file is created. \n"
printf "                  contents must be compared manually with check1.htm. \n\n"

rm -f test.htm
$PROGRAM test.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test.htm ]; then
  printf "Failed: test.htm was not created.\n"
  exit 1
fi

printf "\n 1.0.1 \n"
printf " Test case 1: SD and CV values can be left out optionally. \n"
printf " Test case 2: output filename is given by user. \n"
printf " Expected result: HTML file is created. \n"
printf "                  contents must be compared manually with check2.htm. \n\n"

rm -f test2.htm
$PROGRAM -n test.res test2.htm
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test2.htm ]; then
  printf "Failed: test.htm was not created.\n"
  exit 1
fi



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

