#!/bin/bash
#: Title      : test_fit_gvar
#: Date       : 2017-11-12
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../fit_gvar$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n Make function parameter files for testing \n"

if [ ! -f typical1.fit ]; then
rm -f typical1.dat frames.dat
printf "FIT1        fit_gvar 0.0.0 (c) 2006-2017 Turku PET Centre\n" > typical1.fit
printf "Date:       2017-11-11 16:50:13\n" >> typical1.fit
printf "Data file:  typical1.dat\n" >> typical1.fit
printf "Data unit:  kBq/mL\n" >> typical1.fit
printf "Time unit:  min\n" >> typical1.fit
printf "Nr of VOIs: 1\n" >> typical1.fit
printf "Region        Plane  Start   End     dataNr WSS       parNr Type Parameters\n" >> typical1.fit
printf "000001 .      .        0.000  60.000      8 0.00E+000     6 1403 1 100 0.5 2 30 30\n" >> typical1.fit
fi

if [ ! -f typical.fit ]; then
rm -f typical.dat frames.dat
printf "FIT1        fit_gvar 0.0.0 (c) 2006-2017 Turku PET Centre\n" > typical.fit
printf "Date:       2017-11-11 16:50:13\n" >> typical.fit
printf "Data file:  typical.dat\n" >> typical.fit
printf "Data unit:  kBq/mL\n" >> typical.fit
printf "Time unit:  min\n" >> typical.fit
printf "Nr of VOIs: 3\n" >> typical.fit
printf "Region        Plane  Start   End     dataNr WSS       parNr Type Parameters\n" >> typical.fit
printf "000001 .      .        0.000  60.000      8 0.00E+000     6 1403 1 100 0.5 2 30 30\n" >> typical.fit
printf "000002 .      .        0.000  60.000      8 0.00E+000     6 1403 1 100 0.2 1 5 50\n" >> typical.fit
printf "000003 .      .        0.000  60.000      8 0.00E+000     6 1403 1 50 0.2 20 100 10\n" >> typical.fit
fi


if [ ! -f gvar.fit ]; then
rm -f gvar.dat frames2.dat
printf "FIT1        fit_gvar 0.0.0 (c) 2006-2017 Turku PET Centre\n" > gvar.fit
printf "Date:       2017-11-11 16:50:13\n" >> gvar.fit
printf "Data file:  gvar.dat\n" >> gvar.fit
printf "Data unit:  kBq/mL\n" >> gvar.fit
printf "Time unit:  min\n" >> gvar.fit
printf "Nr of VOIs: 2\n" >> gvar.fit
printf "Region        Plane  Start   End     dataNr WSS       parNr Type Parameters\n" >> gvar.fit
printf "000001 .      .        0.000  60.000      8 0.00E+000     4 1403 1 20 1.0 10\n" >> gvar.fit
printf "000002 .      .        0.000  60.000      8 0.00E+000     4 1403 1 20 0.5 30\n" >> gvar.fit
fi

printf "\n Make limit files \n"

if [ ! -f typical.lim ]; then
printf "p1_lower := 0.9 \n" > typical.lim
printf "p1_upper := 1.1 \n" >> typical.lim
printf "p2_lower := 10 \n"  >> typical.lim
printf "p2_upper := 200 \n" >> typical.lim
printf "p3_lower := 0.1 \n"  >> typical.lim
printf "p3_upper := 0.8 \n" >> typical.lim
printf "p4_lower := 0.5 \n"  >> typical.lim
printf "p4_upper := 50 \n" >> typical.lim
printf "p5_lower := 2 \n"  >> typical.lim
printf "p5_upper := 200 \n" >> typical.lim
printf "p6_lower := 5 \n"  >> typical.lim
printf "p6_upper := 100 \n" >> typical.lim
fi


printf "\n Make frame times files \n"

if [ ! -f frames.dat ]; then
  rm -f typical.dat
  printf "0.5\n0.5\n0.25\n0.25\n0.25\n0.25\n0.5\n0.5\n1\n1\n1\n2\n2\n5\n5\n10\n10\n10\n10\n" > frames.dat
fi
if [ ! -f frames2.dat ]; then
  rm -f gvar.dat
  printf "0.9\n0.1\n0.05\n0.05\n0.1\n0.2\n0.2\n0.2\n0.2\n0.5\n0.5\n1\n1\n1\n2\n2\n5\n5\n5\n5\n5\n5\n" > frames2.dat
fi

printf "\n Make test TAC files \n"

if [ ! -f typical.dat ]; then
  fit2dat -c=0,60,0.05 typical.fit temp.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe temp.dat frames.dat typical.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f gvar.dat ]; then
  fit2dat -c=0,40,0.05 gvar.fit temp.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe temp.dat frames2.dat gvar.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f badfile.dat ]; then
  printf "# badfile\n" > badfile.dat
  printf "ugh banzai\n" >> badfile.dat
  printf "2 meh\n" >> badfile.dat
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Executed with typical data and with default settings. \n"
printf " Expected result: Good fitting result with no errors. \n\n"

rm -f output.fit output.dat stdout.txt
fit2dat -a=60 typical1.fit typical1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -lim=typical.lim typical1.dat output.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=typical1.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output1.svg -s typical1.dat -l output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical1.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: More than one TAC in a file with time frames. \n"
printf " Test case 2: Weighted by frame duration. \n"
printf " Test case 3: SVG saved. \n"
printf " Expected result: Good fitting result with no errors. \n\n"

rm -f output.fit output.dat stdout.txt output2.svg

$PROGRAM -wf -svg=output2.svg -lim=typical.lim typical.dat output.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=typical.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Option -auto. \n"
printf " Expected result: Fit stopped at correct times. \n\n"

cp -f typical.dat test.dat
tacsety test.dat 0 1 -10
tacsety test.dat 1 19 0
tacsety test.dat 2 17 0
tacsety test.dat 3 18 0
tacsety test.dat 3 19 0

rm -f output.fit output.dat stdout.txt output3.svg

$PROGRAM -auto -wf -svg=output3.svg -lim=typical.lim test.dat output.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -tac=1 -ovr temp.fit output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp.fit temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift data_nr 18
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -tac=2 -ovr temp.fit output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp.fit temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift data_nr 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -tac=3 -ovr temp.fit output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp.fit temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift data_nr 17
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Option -thr. \n"
printf " Expected result: samples after low values not fitted. \n\n"

cp -f typical.dat test.dat
tacsety test.dat 1 19 0
tacsety test.dat 2 17 0.1
tacsety test.dat 2 19 0.2

rm -f output.fit output.dat stdout.txt output4.svg

$PROGRAM -thr=1 -wf -svg=output4.svg -lim=typical.lim test.dat output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -tac=1 -ovr temp.fit output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp.fit temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift data_nr 18
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -tac=2 -ovr temp.fit output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp.fit temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift data_nr 16
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -tac=3 -ovr temp.fit output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp.fit temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift data_nr 19
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.3.0 \n"
printf " Test case 1: Option -stoptime. \n"
printf " Test case 2: Option -fitfile. \n"
printf " Expected result: samples after limit not fitted. \n\n"

cp -f typical.dat test.dat
tacsety test.dat 1 19 200
tacsety test.dat 2 19 200
tacsety test.dat 3 19 200

rm -f output.fit output.dat stdout.txt output5a.svg fit.dat output5b.svg

$PROGRAM -stoptime=50 -wf -fit=fit.dat -svg=output5a.svg -lim=typical.lim test.dat output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output5b.svg -s test.dat -l fit.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -tac=3 -ovr temp.fit output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp.fit temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift data_nr 18
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift fit_end "50 min"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.4.0 \n"
printf " Test case: Option -recirc to fit only gamma variate. \n"
printf " Expected result: correct fits. \n\n"


rm -f output.fit output.dat stdout.txt output6.svg

$PROGRAM -recirc=n -wf -svg=output6.svg gvar.dat output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=gvar.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=1.0 -rel=1 gvar.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n===================================================================\n"
printf "   Constraints \n"
printf "===================================================================\n"

printf "\n 3.0.0 \n"
printf " Test case: constraint file is created with option -lim=fname.\n"
printf " Expected result: File is created with correct contents. \n\n"

rm -f output.par
$PROGRAM -lim=output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.par p1_lower
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p1_upper
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p2_lower
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p2_upper
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p3_lower
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p3_upper
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p4_lower
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p4_upper
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p5_lower
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p5_upper
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p6_lower
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.par p6_upper
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.0.1 \n"
printf " Test case: existing constraint file and option -lim=fname.\n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -lim=output.par &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "parameter constraint file output.par exists."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.2 \n"
printf " Test case: trying to use nonexisting constraint file.\n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -lim=nonexisting.par typical.dat output.fit &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexisting.par'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.3 \n"
printf " Test case: trying to use constraint file with bad contents.\n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -lim=badfile.dat typical.dat output.fit &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'badfile.dat'" "file contains no data"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: set constraints for one parameter with -lim.\n"
printf " Expected result: Limits are set correctly. \n\n"

printf "p4_lower := 5\n"  > limit.par
printf "p4_upper := 50\n" >> limit.par

rm -f stdout.txt
$PROGRAM -d4 -lim=limit.par -recirc=no gvar.dat output.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt pmin[3] "5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt pmax[3] "50"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=gvar.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=1.0 -rel=1 gvar.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.0 \n"
printf " Test case: constraints are used to fix a parameter.\n"
printf " Expected result: Limits are set correctly. \n\n"

printf "p1_lower := 1\n"  > limit.par
printf "p1_upper := 1\n" >> limit.par
printf "p5_lower := 0\n" >> limit.par
printf "p5_upper := 0\n" >> limit.par
printf "p6_lower := 0\n" >> limit.par
printf "p6_upper := 0\n" >> limit.par

rm -f stdout.txt
$PROGRAM -d4 -wf -lim=limit.par gvar.dat output.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt pmin[0] "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt pmax[0] "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=gvar.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=1.0 -rel=1 gvar.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


