#!/bin/bash
#: Title      : test_fit_ratf
#: Date       : 2014-09-26
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../fit_ratf$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f p1p1.fit ] || [ ! -f p2p1.fit ] || [ ! -f p2p2.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f p3p2.fit ] || [ ! -f p3p3.fit ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


fit2dat -a=60 p3p3.fit tp3p3.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fit2dat -a=60 p3p2.fit tp3p2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fit2dat -a=60 p2p2.fit tp2p2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fit2dat -a=60 p2p1.fit tp2p1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fit2dat -a=60 p1p1.fit tp1p1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Fit test data with all rational functions. \n"
printf " Test case 2: Parameters are written in format that works with fit2dat. \n"
printf " Test case 3: SVG files are created with option -svg=filename. \n"
printf " Expected result: Good fitting result with no errors. \n"

rm -f output.fit output.dft

$PROGRAM -p3p3 -svg=p3p3.svg tp3p3.dft output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=tp3p3.dft output.fit output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f p3p3.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.001 -rel=0.1 tp3p3.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.fit output.dft

$PROGRAM -p3p2 -svg=p3p2.svg tp3p2.dft output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=tp3p2.dft output.fit output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f p3p2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.001 -rel=0.1 tp3p2.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.fit output.dft

$PROGRAM -p2p2 -svg=p2p2.svg tp2p2.dft output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=tp2p2.dft output.fit output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f p2p2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.001 -rel=0.1 tp2p2.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.fit output.dft

$PROGRAM -p2p1 -svg=p2p1.svg tp2p1.dft output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=tp2p1.dft output.fit output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f p2p1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.001 -rel=0.1 tp2p1.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.fit output.dft

$PROGRAM -p1p1 -svg=p1p1.svg tp1p1.dft output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=tp1p1.dft output.fit output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f p1p1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.001 -rel=0.1 tp1p1.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 1.1.0 \n"
printf " Test case 1: Uses pol3/pol3 function if not specified with option. \n"
printf " Expected result: Correct function is selected. \n"

rm -f output.fit output.dft stdout.txt

$PROGRAM -d2 tp3p3.dft output.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt type 233
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

