#!/bin/bash
#: Title      : test_addtimes
#: Date       : 2018-02-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../addtimes$EXT;


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f addtimes_test1.dat ] || [ ! -f addtimes_test2.dat ] || [ ! -f addtimes_test3.cr ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f addtimes_correct1.dat ] || [ ! -f addtimes_correct2.dat ] || [ ! -f addtimes_correct3.cr ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

cp -f addtimes_test1.dat temp1.dat 
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
cp -f addtimes_test2.dat temp2.dat 
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
cp -f addtimes_test3.cr temp3.cr
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

$PROGRAM temp1.dat temp2.dat temp3.cr
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


iftmatch addtimes_correct1.dat temp1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

iftmatch addtimes_correct2.dat temp2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

iftmatch addtimes_correct3.cr  temp3.cr
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

tac2svg addtimes_test2.svg temp2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

tac2svg addtimes_test3.svg temp3.cr
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"



printf "=====================================================================\n"
printf "  All passed.\n"
printf "=====================================================================\n"
exit 0

