#!/bin/bash
#: Title      : test_dftcat
#: Date       : 2014-10-14
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../dftcat$EXT;

printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n0.1.0 Unknown option \n\n"

rm -f stdout.txt output.dft
$PROGRAM -stupidoption test1a.dft test1b.dft output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.2.0 Extra argument \n\n"

rm -f stdout.txt output.dft
$PROGRAM test1a.dft test1b.dft output.dft extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.3.0 Missing argument \n\n"

rm -f stdout.txt output.dft
$PROGRAM test1a.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n===================================================================\n"

printf "\n0.4.0 file 1 does not exist \n\n"

rm -f stdout.txt output.dft
$PROGRAM nonexistingfile.dft test1b.dft output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n0.4.1 file 2 does not exist \n\n"

rm -f stdout.txt output.dft
$PROGRAM test1a.dft nonexistingfile.ift output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n0.4.2 binary file as input \n\n"

rm -f stdout.txt output.dft
$PROGRAM $PROGRAM test1b.dft output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"

printf "\n0.5.0 datafiles contain different nr of regions. \n\n"

rm -f stdout.txt output.dft
tacadd -ovr temp1b.dft test1b.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacdel temp1b.dft cer
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test1a.dft temp1b.dft output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "different nr of regions."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n1.0.0 output file name is given. Output will be written in there. \n\n"

rm -f stdout.txt output.dft
$PROGRAM test1a.dft test1b.dft output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output1a.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.1.0 output file name is NOT given. \n"
printf "2nd file will be added to the first one. \n\n"

cp -f test1a.dft temp1a.dft
$PROGRAM temp1a.dft test1b.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output1a.dft temp1a.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n2.0.0 combine overlapping curves without option -both \n\n"

rm -f output.kbq
$PROGRAM test2a.kbq test2b.kbq output.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2a.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.0.1 combine overlapping curves with option -both \n\n"

rm -f output.kbq
$PROGRAM -both test2a.kbq test2b.kbq output.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n2.1.0 combine data with partially overlapping time frames \n\n"

rm -f output.dft stdout.txt
tactime test1a.dft +2 temp1a.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM temp1a.dft test1b.dft output.dft &> stdout.txt 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "times in datafiles overlap."
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output_210.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.1.1 combine data with more overlapping time frames \n\n"

rm -f output2.dft stdout.txt
tactime test1a.dft +8 temp1a.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM temp1a.dft test1b.dft output2.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "times in datafiles overlap."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output_211.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n2.2.0 combine overlapping curves with option -first \n\n"

rm -f output.kbq stdout.txt
$PROGRAM -first test2a.kbq test2b.kbq output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "times in datafiles overlap."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2c.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n2.2.1 combine overlapping curves with option -second \n\n"

rm -f output.kbq stdout.txt
$PROGRAM -second test2a.kbq test2b.kbq output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "times in datafiles overlap."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2a.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n3.0.0 combine overlapping curves with option -cut \n"
printf "      cut time inside overlapping data range  \n\n"

rm -f output.kbq stdout.txt
$PROGRAM -cut=22 test2a.kbq test2b.kbq output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2d.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


rm -f output.bld stdout.txt
$PROGRAM -cut=5 test3a.bld test3b.bld output.bld &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output3a.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n3.0.1 combine overlapping curves with option -cut \n"
printf "      cut time given in file  \n\n"

rm -f cuttime.ift output.kbq stdout.txt
printf "cuttime\nx := 22\n" > cuttime.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -cut=cuttime.ift test2a.kbq test2b.kbq output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2d.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"

printf "\n3.1.0 option -cut when data does not overlap \n\n"

rm -f output.dft stdout.txt
$PROGRAM -cut=5 test1a.dft test1b.dft output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output1a.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


rm -f output.dft stdout.txt
$PROGRAM -cut=20 test1a.dft test1b.dft output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output1a.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"

printf "\n3.2.0 combine overlapping curves with option -cut \n"
printf "      but cut time outside of the overlapping data range  \n\n"

rm -f output.kbq stdout.txt
$PROGRAM -cut=5 test2a.kbq test2b.kbq output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2a.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.kbq stdout.txt
$PROGRAM -cut=50 test2a.kbq test2b.kbq output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2c.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"

printf "\n4.0.0 data files have different units \n\n"

cp -f test2a.kbq temp1.dat
cp -f test2b.kbq temp2.dat
rm -f output.dat
tacunit -xset=min -yset=kBq/cc temp1.dat temp2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "program should change the units in file2\n"
tacunit -xconv=sec -yconv=Bq/cc temp2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -second temp1.dat temp2.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2a.kbq output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------------\n"

printf "\n4.1.0 file1 has missing units \n\n"

cp -f test2a.kbq temp1.dat
cp -f test2b.kbq temp2.dat
rm -f output.dat
tacunit -xset=min -yset=kBq/cc temp1.dat temp2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "program should set the units in file1\n"
tacunit -xset=unknown -yset=unknown temp1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -second temp1.dat temp2.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2a.kbq output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------------\n"

printf "\n4.1.1 file2 has missing units \n\n"

cp -f test2a.kbq temp1.dat
cp -f test2b.kbq temp2.dat
rm -f output.dat
tacunit -xset=min -yset=kBq/cc temp1.dat temp2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "program should set the units in file2\n"
tacunit -xset=unknown -yset=unknown temp2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -second temp1.dat temp2.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2a.kbq output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------------\n"

printf "\n4.1.2 both files have missing units \n\n"

cp -f test2a.kbq temp1.dat
cp -f test2b.kbq temp2.dat
rm -f output.dat
tacunit -xset=unknown -yset=unknown temp1.dat temp2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\nprogram should give warnings but still work\n"
$PROGRAM -second temp1.dat temp2.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct_output2a.kbq output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "unknown time units."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "unknown concentration units."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

