#!/bin/bash
#: Title      : test_dftratio
#: Date       : 2018-02-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../dftratio$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# Check that required files exist
if [ ! -f $PROGRAM ]; then
  printf "\nError: application file missing.\n\n"
  exit 1
fi

if [ ! -f dftratio.dft ]; then
  rm -f dftratio_sec.dft reference.dft dftratio_nr.dft
  printf "DFT         roi1  roi2  roi3  ref \n"    > dftratio.dft
  printf "exam0001    .     .     .     .\n"      >> dftratio.dft
  printf "kBq/ml      pl18  pl18  pl19  pl28\n"   >> dftratio.dft
  printf "Times (min) 675.2 712.8 456.6 9167.1\n" >> dftratio.dft
  printf "0.00 1.00   1.00  2.00  3.00  2.00\n"   >> dftratio.dft
  printf "1.00 2.00   3.00  6.00  9.00  6.00\n"   >> dftratio.dft
  printf "2.00 3.00   6.00  12.0  12.0  12.0\n"   >> dftratio.dft
  printf "3.00 4.00   9.00  15.0  14.0  11.0\n"   >> dftratio.dft
  printf "4.00 5.00   12.0  17.0  15.0  9.00\n"   >> dftratio.dft
  printf "5.00 10.0   15.0  16.0  16.0  6.00\n"   >> dftratio.dft
  printf "10.0 15.0   17.0  15.0  16.0  4.00\n"   >> dftratio.dft
  printf "15.0 20.0   18.0  14.0  16.0  3.00\n"   >> dftratio.dft
  printf "20.0 30.0   19.0  13.0  16.0  2.00\n"   >> dftratio.dft
  printf "30.0 40.0   20.0  12.0  16.0  1.50\n"   >> dftratio.dft
  printf "40.0 60.0   21.0  11.0  16.0  1.00\n"   >> dftratio.dft
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f dftratio_sec.dft ]; then
  cp -f dftratio.dft dftratio_sec.dft
  tacunit -xconv=sec dftratio_sec.dft
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f reference.dft ]; then
  tacadd -ovr reference.dft dftratio.dft ref
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f dftratio_nr.dft ]; then
  cp -f dftratio.dft dftratio_nr.dft
  tacdel dftratio_nr.dft ref
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_1_0_0.res ]; then
  printf "dftratio 0.6.19 (c) 2018 by Turku PET Centre\n\n" > correct_1_0_0.res
  printf "Date:	2018-02-04 08:53:45\n"              >> correct_1_0_0.res
  printf "Study:	exam0001\n"                 >> correct_1_0_0.res
  printf "Data file:	dftratio.dft\n"             >> correct_1_0_0.res
  printf "Reference region:	ref . pl28\n"       >> correct_1_0_0.res
  printf "Data range:	0 - 60 min\n"               >> correct_1_0_0.res
  printf "Data nr:	11\n"                       >> correct_1_0_0.res
  printf "Weighting:	no\n\n"                     >> correct_1_0_0.res
  printf "Region		B/F	tMax\n"     >> correct_1_0_0.res
  printf "# Units:	.	min\n"              >> correct_1_0_0.res
  printf "roi1 . pl18	2.00e+01	5.00e+01\n" >> correct_1_0_0.res
  printf "roi2 . pl18	2.75e+00	1.25e+01\n" >> correct_1_0_0.res
  printf "roi3 . pl19	1.50e+01	5.00e+01\n" >> correct_1_0_0.res
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_1_1_0.res ]; then
  printf "dftratio 0.6.19 (c) 2018 by Turku PET Centre\n\n" > correct_1_1_0.res
  printf "Date:	2018-02-04 08:53:45\n"         >> correct_1_1_0.res
  printf "Study:	exam0001\n"            >> correct_1_1_0.res
  printf "Data file:	dftratio.dft\n"        >> correct_1_1_0.res
  printf "Reference region:	ref . pl28\n"  >> correct_1_1_0.res
  printf "Data range:	20 - 30 min\n"         >> correct_1_1_0.res
  printf "Data nr:	11\n"                  >> correct_1_1_0.res
  printf "Weighting:	no\n\n"                >> correct_1_1_0.res
  printf "Region		B/F	AUC\n" >> correct_1_1_0.res
  printf "# Units:	.	min\n"         >> correct_1_1_0.res
  printf "roi1 . pl18	8.0	1.685e+02\n"   >> correct_1_1_0.res
  printf "roi2 . pl18	5.2	1.094e+02\n"   >> correct_1_1_0.res
  printf "roi3 . pl19	6.6	1.389e+02\n"   >> correct_1_1_0.res
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_1_2_0.res ]; then
  printf "dftratio 0.6.19 (c) 2018 by Turku PET Centre\n\n" > correct_1_2_0.res
  printf "Date:	2018-02-04 08:53:45\n"         >> correct_1_2_0.res
  printf "Study:	exam0001\n"            >> correct_1_2_0.res
  printf "Data file:	dftratio.dft\n"        >> correct_1_2_0.res
  printf "Reference region:	ref . pl28\n"  >> correct_1_2_0.res
  printf "Data range:	20 - 30 min\n"         >> correct_1_2_0.res
  printf "Data nr:	11\n"                  >> correct_1_2_0.res
  printf "Weighting:	no\n\n"                >> correct_1_2_0.res
  printf "Region		T/F	AUC\n" >> correct_1_2_0.res
  printf "# Units:	.	min\n"         >> correct_1_2_0.res
  printf "roi1 . pl18	19.2	4.167e+02\n"   >> correct_1_2_0.res
  printf "roi2 . pl18	10.3	2.233e+02\n"   >> correct_1_2_0.res
  printf "roi3 . pl19	14.7	3.200e+02\n"   >> correct_1_2_0.res
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi







printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Max of bound TAC. \n"
printf " Test case 2: Reference region inside the same file. \n"
printf " Expected result: Correct ratio and time. \n\n"

rm -f output.res

$PROGRAM -max dftratio.dft ref 0 90 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch correct_1_0_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -max dftratio_sec.dft ref 0 90 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -roughly -res=1 -header=n correct_1_0_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Max of bound TAC. \n"
printf " Test case 2: Reference region inside separate file. \n"
printf " Expected result: Correct ratio and time. \n\n"

rm -f output.res

$PROGRAM -max dftratio_nr.dft reference.dft 0 90 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -roughly -header=n correct_1_0_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Bound ratio inside time range. \n"
printf " Test case 2: Reference region inside the same file. \n"
printf " Expected result: Correct ratio and AUC. \n\n"

rm -f output.res

$PROGRAM -bound dftratio.dft ref 20 30 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -roughly correct_1_1_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -bound dftratio_sec.dft ref 20 30 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -roughly -res=1 -header=n correct_1_1_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Bound ratio inside time range. \n"
printf " Test case 2: Reference region inside separate file. \n"
printf " Expected result: Correct ratio and AUC. \n\n"

rm -f output.res

$PROGRAM -bound dftratio_nr.dft reference.dft 20 30 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -roughly -header=n correct_1_1_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.2.0 \n"
printf " Test case 1: Ratio inside time range. \n"
printf " Test case 2: Reference region inside the same file. \n"
printf " Expected result: Correct ratio and AUC. \n\n"

rm -f output.res

$PROGRAM dftratio.dft ref 40 60 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -roughly correct_1_2_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM dftratio_sec.dft ref 40 60 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -roughly -res=1 -header=n correct_1_2_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case 1: Ratio inside time range. \n"
printf " Test case 2: Reference region inside separate file. \n"
printf " Expected result: Correct ratio and AUC. \n\n"

rm -f output.res

$PROGRAM dftratio_nr.dft reference.dft 40 60 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -roughly -header=n correct_1_2_0.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.0.0 \n"
printf " Test case 1: Save ratio curve. \n"
printf " Test case 2: Reference region inside the same file. \n"
printf " Test case 3: Bound per reference. \n"
printf " Expected result: Correct ratio curves saved. \n\n"

rm -f output.dft
taccalc dftratio_nr.dft - reference.dft test1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccalc test1.dft div reference.dft test.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -bound -rat=output.dft dftratio.dft ref 40 60 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 test.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Save ratio curve. \n"
printf " Test case 2: Reference region in separate file. \n"
printf " Test case 3: Max of bound per reference. \n"
printf " Expected result: Correct ratio curves saved. \n\n"

rm -f output.dft

$PROGRAM -max -rat=output.dft dftratio_nr.dft reference.dft 40 60 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 test.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case 1: Save ratio curve. \n"
printf " Test case 2: Reference region inside the same file. \n"
printf " Test case 3: total per reference. \n"
printf " Expected result: Correct ratio curves saved. \n\n"

rm -f output.dft
taccalc dftratio_nr.dft div reference.dft test.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -rat=output.dft dftratio.dft ref 10 60 output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 test.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0
