#!/bin/bash
#: Title      : test_dcmframe
#: Date       : 2017-11-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dcmframe$EXT;


printf "\n====================================================================\n"
printf "verifying that required data exists for %s\n" $PROGRAM
printf "====================================================================\n"


if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

DCMFILE1=../dicom/f170.dcm
if [ ! -f $DCMFILE1 ]; then
  printf "Failed: test file does not exist.\n"
  exit 1
fi
DCMFILE2=../dicom/f30.dcm
if [ ! -f $DCMFILE2 ]; then
  printf "Failed: test file does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: List frame data default settings. \n"
printf " Expected result: Contents are listed. \n\n"

rm -f output.ift

$PROGRAM -d $DCMFILE1 > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "frameNr" "24"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.0 \n"
printf " Test case: Save frames in a SIF. \n"
printf " Expected result: SIF is saved. \n\n"

rm -f output.ift output.sif

$PROGRAM -d $DCMFILE1 output.sif > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "frameNr" "24"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacformat output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Static whole-body with no frame nr. \n"
printf " Expected result: SIF is saved. \n\n"

rm -f output2.ift output2.sif

$PROGRAM -d $DCMFILE2 output2.sif > output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output2.ift "frameNr" "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacformat output2.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

