#!/bin/bash
#: Title      : test_csv2ift
#: Date       : 2014-10-21
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../csv2ift$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f example.csv ] || [ ! -f correct.ift ]; then
  rm -f example.csv correct.ift
  printf "1,2,3\n4,5,6\n7,8,9\n10,11,12\n" > example.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "[1][1] := 1\n" >> correct.ift
  printf "[1][2] := 2\n" >> correct.ift
  printf "[1][3] := 3\n" >> correct.ift
  printf "[2][1] := 4\n" >> correct.ift
  printf "[2][2] := 5\n" >> correct.ift
  printf "[2][3] := 6\n" >> correct.ift
  printf "[3][1] := 7\n" >> correct.ift
  printf "[3][2] := 8\n" >> correct.ift
  printf "[3][3] := 9\n" >> correct.ift
  printf "[4][1] := 10\n" >> correct.ift
  printf "[4][2] := 11\n" >> correct.ift
  printf "[4][3] := 12\n" >> correct.ift
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n\n"
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Convert CSV table into IFT. \n"
printf " Expected result: Correct contents. \n\n"

rm -f output.ift
$PROGRAM example.csv output.ift 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch correct.ift output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
