#!/bin/bash
#: Title      : test_iftisval
#: Date       : 2014-10-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../iftisval$EXT;

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n0.1.0\n"

printf "Nonexisting argument file should give an error\n"
$PROGRAM -d nonexistingfile.ift key value
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.1.0\n"

printf "Binary file as argument file should not crash program\n"
$PROGRAM -d $PROGRAM key value
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.0\n"

printf "Nonexisting key should return 10\n"
$PROGRAM -d test4.ift nothiskey
if [ $? -ne 10 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.1\n"

printf "Nonexisting key and value should return 10\n"
$PROGRAM -d test4.ift nothiskey nothisvalue
if [ $? -ne 10 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.1\n"

printf "Existing key without value should return 0\n"
$PROGRAM -d test4.ift unit
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.2\n"

printf "Existing key with nonexisting value should return 11\n"
$PROGRAM -d test4.ift unit kBq/mL
if [ $? -ne 11 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.3\n"

printf "Existing key with existing value with single occurrence should return 0\n"
$PROGRAM -d test4.ift calibrated yes
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.4\n"

printf "Existing key with existing value at 3rd occurrence should return 0\n"
$PROGRAM -d test4.ift patient_name "vesa oikonen"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.1.0\n"

printf "Negative value must not be identified as an option\n"
$PROGRAM -d test4.ift scan_start_time_difference -15
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
printf "not even if there are no options at all\n"
$PROGRAM test4.ift scan_start_time_difference -15
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.2.0\n"

printf "Date and time is identified as value\n"
$PROGRAM -d test4.ift date "2010-05-19 15:04:21"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.2.1\n"

printf "program must not identify ':' in time as an equal sign\n"
$PROGRAM -d test4.ift "2010-05-19 15:04:21" Yes
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d test4.ift "2010-05-19 15:34:21" No
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.2.2\n"

printf "equal sign inside quotation marks must not be identified\n"
$PROGRAM -d test4.ift value_12:00:21 3.14
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n1.3.0\n"

printf "option -abs can be used to match numerical values\n"
$PROGRAM -d -abs=2 test4.ift scan_start_time_difference -14
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -abs=1 test4.ift scan_start_time_difference -13
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.3.1\n"

printf "also with decimal numbers\n"
$PROGRAM -d -abs=0.02 test4.ift "value_12:00:21" 3.13
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -abs=0,02 test4.ift "value_12:00:21" 3,13
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.3.2\n"

printf "zero difference can be requested\n"
$PROGRAM -d -abs=0.0 test4.ift "value_12:00:21" 3.140000
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -abs=0,0 test4.ift "value_12:00:21" 3,140000
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "\n1.4.0\n"

printf "option -lt can be used to verify numerical values\n"
$PROGRAM -d -lt test4.ift scan_start_time_difference -14
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -lt test4.ift scan_start_time_difference -16
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.4.1\n"

printf "option -lt works with decimal numbers\n"
$PROGRAM -d -lt test4.ift "value_12:00:21" 3.15
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -lt test4.ift "value_12:00:21" 3,15
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.4.2\n"

printf "option -lt does not accept zero difference\n"
$PROGRAM -d -lt test4.ift "value_12:00:21" 3.140000
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -lt test4.ift "value_12:00:21" 3,140000
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "\n1.5.0\n"

printf "option -gt can be used to verify numerical values\n"
$PROGRAM -d -gt test4.ift scan_start_time_difference -16
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -gt test4.ift scan_start_time_difference -14
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.5.1\n"

printf "option -gt works with decimal numbers\n"
$PROGRAM -d -gt test4.ift "value_12:00:21" 3.13
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -gt test4.ift "value_12:00:21" 3,13
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.5.2\n"

printf "option -gt does not accept zero difference\n"
$PROGRAM -d -gt test4.ift "value_12:00:21" 3.140000
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
$PROGRAM -d -gt test4.ift "value_12:00:21" 3,140000
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
