#!/bin/bash
#: Title      : test_iftvalc
#: Date       : 2017-09-22
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../iftvalc$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Just operate two numbers in two files. \n"
printf " Expected result: Correct result written in file. \n\n"

printf "6\n" > test1.ift
printf "2\n" > test2.ift
printf "8\n" > sum.ift
printf "3\n" > div.ift
printf "4\n" > minus.ift
printf "12\n" > mult.ift

rm -f output.ift
$PROGRAM test1.ift all + test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


rm -f output.ift
$PROGRAM test1.ift all - test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch minus.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.ift
$PROGRAM test1.ift all x test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch mult.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.ift
$PROGRAM test1.ift all div test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch div.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: matching key names and item number. \n"
printf " Test case 2: no key names given. \n"
printf " Expected result: Correct result written in file. \n\n"

printf "key1 := 6\n" > test1.ift
printf "key1 := 2\n" > test2.ift
printf "key1 := 8\n" > sum.ift

rm -f output.ift
$PROGRAM test1.ift all + test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: two items in different order. \n"
printf " Expected result: Correct result written in file. \n\n"

printf "key1 := 6\n" >  test1.ift
printf "key2 := 4\n" >> test1.ift

printf "key2 := 3\n" >  test2.ift
printf "key1 := 2\n" >> test2.ift

printf "key1 := 8\n" >  sum.ift
printf "key2 := 7\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift all + test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: no key names given. \n"
printf " Test case 2: 2nd file contains only one value. \n"
printf " Expected result: All values in 1st file operated with the one value. \n\n"

printf "key1 := 6\n" >  test1.ift
printf "key2 := 4\n" >> test1.ift
printf "key3 := 2\n" >> test1.ift

printf "key2 := 3\n" >  test2.ift

printf "key1 := 9\n" >  sum.ift
printf "key2 := 7\n" >> sum.ift
printf "key3 := 5\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift all + test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case: same but files do not have keys either. \n"

printf " Expected result: All values in 1st file operated with the one value. \n\n"

printf "6\n" >  test1.ift
printf "4\n" >> test1.ift
printf "2\n" >> test1.ift

printf "3\n" >  test2.ift

printf "9\n" >  sum.ift
printf "7\n" >> sum.ift
printf "5\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift all + test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case 1: only selected item in file1 is processed. \n"
printf " Test case 2: 2nd file contains only one value. \n"
printf " Expected result: Correct results written in file. \n\n"

printf "key1 := 6\n" >  test1.ift
printf "key2 := 4\n" >> test1.ift
printf "key3 := 2\n" >> test1.ift

printf "key2 := 3\n" >  test2.ift

printf "key1 := 6\n" >  sum.ift
printf "key2 := 4\n" >> sum.ift
printf "key3 := 5\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift key3 + test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case 1: only selected item in file1 is processed. \n"
printf " Test case 2: 2nd file contains several values but one with the same key. \n"
printf " Expected result: Correct results written in file. \n\n"

printf "key1 := 6\n" >  test1.ift
printf "key2 := 4\n" >> test1.ift
printf "key3 := 2\n" >> test1.ift

printf "key2 := 3\n" >  test2.ift
printf "key1 := 1\n" >> test2.ift
printf "key3 := 1\n" >> test2.ift

printf "key1 := 6\n" >  sum.ift
printf "key2 := 7\n" >> sum.ift
printf "key3 := 2\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift key2 + test2.ift all output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.2 \n"
printf " Test case 1: only selected item in file1 is processed. \n"
printf " Test case 2: 2nd file contains only one value without key names. \n"
printf " Test case 3: Output filename not given. \n"
printf " Expected result: Correct results written in file. \n\n"

printf "key1 := 6\n" >  test1.ift
printf "key2 := 4\n" >> test1.ift
printf "key3 := 2\n" >> test1.ift

printf "3\n" >  test2.ift

printf "key1 := 6\n" >  sum.ift
printf "key2 := 7\n" >> sum.ift
printf "key3 := 2\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift key2 + test2.ift none 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch sum.ift test1.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 2.0.0 \n"
printf " Test case 1: files have different nr of items. \n"
printf " Test case 2: specified key in 2nd file is used. \n"
printf " Expected result: Correct result written in file. \n\n"

printf "key1 := 6\n" >  test1.ift
printf "key2 := 4\n" >> test1.ift
printf "key3 := 2\n" >> test1.ift

printf "key2 := 3\n" >  test2.ift

printf "key1 := 9\n" >  sum.ift
printf "key2 := 7\n" >> sum.ift
printf "key3 := 5\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift all + test2.ift key2 output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: specified key in 2nd file is not found. \n"
printf " Expected result: Error. \n\n"

rm -f output.ift
$PROGRAM test1.ift all + test2.ift key4 output.ift 
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: specified key in 2nd file is found but value is invalid. \n"
printf " Expected result: Error. \n\n"

printf "key2 := kukkuu\n" >  test2.ift

rm -f output.ift
$PROGRAM test1.ift all + test2.ift key2 output.ift 
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case 1: file1 does not have keys. \n"
printf " Test case 2: specified key in 2nd file is used. \n"
printf " Expected result: Correct result written in file. \n\n"

printf "6\n" >  test1.ift
printf "4\n" >> test1.ift
printf "2\n" >> test1.ift

printf "key2 := 3\n" >  test2.ift

printf "9\n" >  sum.ift
printf "7\n" >> sum.ift
printf "5\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift all + test2.ift key2 output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.2.0 \n"
printf " Test case: item with specified key in both files is used. \n"
printf " Expected result: Correct result written in file. \n\n"

printf "key1 := 6\n" >  test1.ift
printf "key2 := 4\n" >> test1.ift
printf "key3 := 2\n" >> test1.ift

printf "key1 := 1\n" >  test2.ift
printf "key2 := 3\n" >> test2.ift
printf "key3 := 2\n" >> test2.ift

printf "key1 := 6\n" >  sum.ift
printf "key2 := 4\n" >> sum.ift
printf "key3 := 5\n" >> sum.ift

rm -f output.ift
$PROGRAM test1.ift key3 + test2.ift key2 output.ift 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch sum.ift output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.1 \n"
printf " Test case: specified key in 1st file is not found. \n"
printf " Expected result: Error. \n\n"

rm -f output.ift
$PROGRAM test1.ift key4 + test2.ift key2 output.ift 
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: specified key in 1st file is found but value is invalid. \n"
printf " Expected result: Error. \n\n"

printf "key1 := 6\n" >  test1.ift
printf "key2 := kukkuu\n" >> test1.ift
printf "key3 := 2\n" >> test1.ift

rm -f output.ift
$PROGRAM test1.ift key2 + test2.ift key2 output.ift 
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
