#!/bin/bash
#: Title      : test_b2rbc
#: Date       : 2014-10-19
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../b2rbc$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n\n Making data for testing \n\n"

if [ ! -f blood.dat ] || [ ! -f blood.bld ]; then
  printf "1 0\n2 48\n3 24\n10 12\n" > blood.dat
  tacformat -f=PMOD -hdr=no -mid blood.dat blood.bld 
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacunit -xset=min -yset=kBq/mL blood.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f plasma.dat ] || [ ! -f plasma.bld ]; then
  printf "1 0\n2 40\n3 20\n10 10\n" > plasma.dat
  tacformat -f=PMOD -hdr=no -mid plasma.dat plasma.bld 
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacunit -xset=min -yset=kBq/mL plasma.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f rbc.dat ] || [ ! -f rbc.bld ]; then
  printf "1 0\n2 60\n3 30\n10 15\n" > rbc.dat
  tacformat -f=PMOD -hdr=no -mid rbc.dat rbc.bld 
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacunit -xset=min -yset=kBq/mL rbc.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: HCT given as fraction. \n"
printf " Expected result: Correct RBC curve calculated. \n\n"

rm -f output.dat
$PROGRAM blood.dat plasma.dat 0.40 output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 rbc.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: HCT given as percentage. \n"
printf " Expected result: Correct RBC curve calculated. \n\n"

rm -f output.dat
$PROGRAM blood.dat plasma.dat 40 output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 rbc.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: HCT given as fraction with decimal comma. \n"
printf " Expected result: Correct RBC curve calculated. \n\n"

rm -f output.dat
$PROGRAM blood.dat plasma.dat 0,40 output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 rbc.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  Testing units and file formats\n"
printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case 1: kBq/ml and Bq/ml are automatically converted. \n"
printf " Test case 2: min and sec are automatically converted. \n"
printf " Test case 3: PMOD BLD format. \n"
printf " Expected result: Correct RBC curve calculated, in units of blood TAC. \n\n"

rm -f output.bld
cp -f blood.bld temp.bld
cp -f rbc.bld temp2.bld
tacunit -xconv=sec -yconv=Bq/mL temp.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tacunit -xconv=sec -yconv=Bq/mL temp2.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM temp.bld plasma.bld 0.40 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -yunit=y -abs=0.00001 temp2.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


rm -f output.bld
cp -f plasma.bld temp.bld
tacunit -xconv=sec -yconv=Bq/mL temp.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM blood.bld temp.bld 0.40 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -yunit=y -abs=0.00001 rbc.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
