#!/bin/bash
#: Title      : test_fit_pbr
#: Date       : 2019-05-10
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_pbr$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

printf "\n creating data for testing \n"

if [ ! -f test1.dat ] || [ ! -f test2.dat ] || [ ! -f test3.dat ] || [ ! -f test4.dat ]; then
printf "0.01	1.683192984	1.810807226	1.818178821	1.817438466\n" > test.dat
printf "1	0.862806237	1.439702883	1.817663531	1.74805136\n" >> test.dat
printf "2	1.398912975	1.352580648	1.816707261	1.685546636\n" >> test.dat
printf "3	1.713904284	1.350605649	1.815318766	1.629549878\n" >> test.dat
printf "4	1.798437178	1.378813538	1.813504365	1.579152276\n" >> test.dat
printf "5	1.814811224	1.415450508	1.811270909	1.533607331\n" >> test.dat
printf "6	1.817633575	1.45076987	1.808625753	1.49229616\n" >> test.dat
printf "7	1.818095233	1.480755498	1.805576726	1.454701345\n" >> test.dat
printf "8	1.818168426	1.504378993	1.802132101	1.420386956\n" >> test.dat
printf "9	1.818179779	1.52207751	1.798300566	1.388983113\n" >> test.dat
printf "10	1.818181512	1.534867848	1.794091187	1.360173929\n" >> test.dat
printf "15	1.818181818	1.558983639	1.767716671	1.246721408\n" >> test.dat
printf "20	1.818181818	1.56211105	1.733419363	1.169445226\n" >> test.dat
printf "30	1.818181818	1.562496034	1.646558407	1.078394065\n" >> test.dat
printf "40	1.818181818	1.562499964	1.544229471	1.036106756\n" >> test.dat
printf "50	1.818181818	1.5625	1.435545477	1.021734401\n" >> test.dat
printf "60	1.818181818	1.5625	1.327216618	1.025021385\n" >> test.dat
printf "70	1.818181818	1.5625	1.223595781	1.040204282\n" >> test.dat
printf "80	1.818181818	1.5625	1.127132986	1.063675479\n" >> test.dat
printf "90	1.818181818	1.5625	1.038921791	1.092961067\n" >> test.dat
printf "100	1.818181818	1.5625	0.959177012	1.126231954\n" >> test.dat
printf "# timeunit := min\n" >> test.dat
  tacadd -ovr test1.dat test.dat 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr test2.dat test.dat 2
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr test3.dat test.dat 3
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr test4.dat test.dat 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f test1.lim ] || [ ! -f test2.lim ] || [ ! -f test3.lim ] || [ ! -f test4.lim ]; then

printf "HCT_lower := 0.36\n" > test1.lim
printf "HCT_upper := 0.5\n" >> test1.lim
printf "A_lower := 0.1\n" >> test1.lim
printf "A_upper := 100\n" >> test1.lim
printf "L_lower := 0.1\n" >> test1.lim
printf "L_upper := 5\n" >> test1.lim
printf "k_lower := 0\n" >> test1.lim
printf "k_upper := 0.1\n" >> test1.lim

printf "HCT_lower := 0.36\n" > test2.lim
printf "HCT_upper := 0.5\n" >> test2.lim
printf "A_lower := 0.1\n" >> test2.lim
printf "A_upper := 5.0\n" >> test2.lim
printf "L_lower := 0.01\n" >> test2.lim
printf "L_upper := 1\n" >> test2.lim
printf "k_lower := 0.01\n" >> test2.lim
printf "k_upper := 0.50\n" >> test2.lim

printf "HCT_lower := 0.36\n" > test3.lim
printf "HCT_upper := 0.5\n" >> test3.lim
printf "A_lower := 1e-06\n" >> test3.lim
printf "A_upper := 0.1\n" >> test3.lim
printf "L_lower := 1e-06\n" >> test3.lim
printf "L_upper := 0.1\n" >> test3.lim
printf "k_lower := 0.1\n" >> test3.lim
printf "k_upper := 3\n" >> test3.lim

printf "HCT_lower := 0.36\n" > test4.lim
printf "HCT_upper := 0.5\n" >> test4.lim
printf "A_lower := 1e-06\n" >> test4.lim
printf "A_upper := 0.5\n" >> test4.lim
printf "L_lower := 1e-06\n" >> test4.lim
printf "L_upper := 0.5\n" >> test4.lim
printf "k_lower := 0\n" >> test4.lim
printf "k_upper := 0.1\n" >> test4.lim

fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Fit TAC with suitable limits. \n"
printf " Test case 2: HCT fixed. \n"
printf " Test case 3: Parameters saved in FIT format. \n"
printf " Test case 4: SVG plot saved. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f test1.svg test1.fit
$PROGRAM -lim=test1.lim -HCT=0.45 -svg=test1.svg test1.dat test1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat test1.fit
if [ ! -f test1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test1.dat test1.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=1 test1.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f test2.svg test2.fit
$PROGRAM -lim=test2.lim -HCT=0.45 -svg=test2.svg test2.dat test2.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test2.dat test2.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=1 test2.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f test3.svg test3.fit
$PROGRAM -lim=test3.lim -HCT=0.45 -svg=test3.svg test3.dat test3.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test3.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test3.dat test3.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=1 test3.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f test4.svg test4.fit
$PROGRAM -lim=test4.lim -HCT=0.45 -svg=test4.svg test4.dat test4.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test4.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test4.dat test4.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=1 test4.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Fit TAC with suitable limits. \n"
printf " Test case 2: HCT not fixed. \n"
printf " Test case 3: Parameters saved in FIT format. \n"
printf " Test case 4: SVG plot saved. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f test1.svg test1.fit
$PROGRAM -lim=test1.lim -svg=test1.svg test1.dat test1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat test1.fit
if [ ! -f test1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test1.dat test1.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=1 test1.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f test2.svg test2.fit
$PROGRAM -lim=test2.lim -svg=test2.svg test2.dat test2.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test2.dat test2.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=1 test2.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f test3.svg test3.fit
$PROGRAM -lim=test3.lim -svg=test3.svg test3.dat test3.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test3.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test3.dat test3.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=1 test3.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f test4.svg test4.fit
$PROGRAM -lim=test4.lim -svg=test4.svg test4.dat test4.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f test4.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=test4.dat test4.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=1 test4.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Fit TAC with suitable limits. \n"
printf " Test case 2: Absolute deviations minimized. \n"
printf " Expected result 1: optimality criterion in results. \n"
printf " Expected result 2: reasonable fit is obtained. \n\n"

rm -f test1.fit test1.par
$PROGRAM -min=LAD -lim=test1.lim test1.dat test1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat test1.fit
fit2dat -f=test1.dat test1.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=10 test1.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -min=LAD -lim=test1.lim -svg=test1.svg test1.dat test1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat test1.par
iftisval test1.par "optimality_criterion" "LAD"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

