#!/bin/bash
#: Title      : test_liverinp
#: Date       : 2018-05-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../liverinp$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f arterial.dat ] || [ ! -f portal.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct1.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Portal vein proportion 0.9. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

rm -f output1.dat
$PROGRAM portal.dat arterial.dat 0.9 output1.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 correct1.dat output1.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: Portal vein proportion given as percentage. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

rm -f output2.dat
$PROGRAM portal.dat arterial.dat 90 output2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 correct1.dat output2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Input files given in wrong order. \n"
printf " Expected result: Warning. \n\n"

rm -f stdout.txt output3.dat
$PROGRAM arterial.dat portal.dat 0.90 output3.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "unexpectedly portal vein has higher peak than hepatic artery."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
