#!/bin/bash
#: Title      : test_o2_p2w
#: Date       : 2016-02-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../o2_p2w$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f s03105ap.kbq ] || [ ! -f correct_s03105wb.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Usual data with default settings. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

rm -f output.dat
$PROGRAM s03105ap.kbq output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n -xunit=y -abs=0.01 -rel=0.1 s03105ap.kbq output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=0.1 correct_s03105wb.bld output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Sample collection time set to 20 s. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

rm -f output.dat
$PROGRAM -sct=20 s03105ap.kbq output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.01 -rel=0.1 correct_s03105wb.bld output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Plasma-to-blood ratio is set to 1.12. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

rm -f output.dat
$PROGRAM -pbr=1.12 -sct=20 s03105ap.kbq output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.01 -rel=0.1 correct_s03105wb.bld output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: HCT  is set to 0.4796. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

rm -f output.dat
$PROGRAM -hct=0.4796 -sct=20 s03105ap.kbq output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.01 -rel=0.1 correct_s03105wb.bld output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
