/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpctac.h"
#include "tpctacmod.h"
#include "test_tpcbfm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_spectralDExp(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;

  ret=spectralDExp(NULL, NULL, NULL, 0, 0.0, 0.0, 0, NULL, NULL, NULL, NULL);
  if(verbose>1) printf("\ndid not segfault, that is good.\n");
  if(ret==TPCERROR_OK) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_spectralKRange(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;

  ret=spectralKRange(NULL, NULL, 0, NULL, NULL, NULL);
  if(verbose>1) printf("\ndid not segfault, that is good.\n");
  if(ret==TPCERROR_OK) return(1);

  {
    int n=10; double a[n], k[n];
    a[0]=0.0; k[0]=1.0;
    a[1]=0.0; k[1]=0.0;
    a[2]=0.1; k[2]=0.18;
    a[3]=0.9; k[3]=0.02;
    a[4]=0.0; k[4]=1.0;
    a[5]=2.0; k[5]=0.09;
    a[6]=0.0; k[6]=1.0;
    a[7]=0.9; k[7]=0.002;
    a[8]=0.1; k[8]=0.018;
    a[9]=0.0; k[9]=0.0;
    if(spectralKRange(k, a, n, NULL, NULL, status)!=TPCERROR_OK) return(101);
    double kmin, kmax;
    if(spectralKRange(k, a, n, &kmin, &kmax, status)!=TPCERROR_OK) return(102);
    if(!doubleMatch(kmin, 0.002, 1.0E-10) || !doubleMatch(kmax, 0.18, 1.0E-10)) return(103);
    if(spectralKRange(k+1, a+1, n-1, &kmin, &kmax, status)!=TPCERROR_OK) return(110);
    if(!doubleMatch(kmin, 0.002, 1.0E-10) || !doubleMatch(kmax, 0.18, 1.0E-10)) return(111);
    if(spectralKRange(k, a, n-1, &kmin, &kmax, status)!=TPCERROR_OK) return(121);
    if(!doubleMatch(kmin, 0.002, 1.0E-10) || !doubleMatch(kmax, 0.18, 1.0E-10)) return(122);
    if(spectralKRange(k+2, a+2, n-3, &kmin, &kmax, status)!=TPCERROR_OK) return(131);
    if(!doubleMatch(kmin, 0.002, 1.0E-10) || !doubleMatch(kmax, 0.18, 1.0E-10)) return(132);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_spectralBFNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int m;

  m=spectralBFNr(NULL, NULL, 0);
  if(verbose>1) printf("\ndid not segfault, that is good.\n");
  if(m!=0) return(1);

  {
    int n=10; double a[n], k[n];
    a[0]=0.0; k[0]=1.0;
    a[1]=0.0; k[1]=0.0;
    a[2]=0.1; k[2]=0.18;
    a[3]=0.9; k[3]=0.02;
    a[4]=0.0; k[4]=1.0;
    a[5]=2.0; k[5]=0.09;
    a[6]=0.0; k[6]=1.0;
    a[7]=0.9; k[7]=0.002;
    a[8]=0.1; k[8]=0.018;
    a[9]=0.0; k[9]=0.0;
    if(spectralBFNr(k, a, n)!=3) return(101);
    if(spectralBFNr(k+1, a+1, n-1)!=3) return(102);
    if(spectralBFNr(k, a, n-1)!=3) return(103);
    if(spectralBFNr(k+2, a+2, n-3)!=3) return(104);
    if(spectralBFNr(k, a, 2)!=0) return(105);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_spectralBFExtract(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int m;

  m=spectralBFExtract(NULL, NULL, 0, NULL, NULL, 0);
  if(verbose>1) printf("\ndid not segfault, that is good.\n");
  if(m!=0) return(1);
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  {
    int n=10; double a[n], k[n], ae[n], ke[n];
    a[0]=0.0; k[0]=1.0;
    a[1]=0.0; k[1]=0.0;
    a[2]=0.1; k[2]=0.18;
    a[3]=0.9; k[3]=0.02;
    a[4]=0.0; k[4]=1.0;
    a[5]=2.0; k[5]=0.09;
    a[6]=0.0; k[6]=1.0;
    a[7]=9.0; k[7]=0.002;
    a[8]=1.0; k[8]=0.018;
    a[9]=0.0; k[9]=0.0;
    if(verbose>2) {
      printf("\nOriginal data:\n\tA\tB\n");
      for(int i=0; i<n; i++) printf("\t%g\t%g\n", a[i], k[i]);
      fflush(stdout);
    }
    int ne;
    if((ne=spectralBFExtract(k, a, n, ke, ae, 5))!=3) return(101);
    if(verbose>2) {
      printf("\n -> clusters:\n\tA\tB\n");
      for(int i=0; i<ne; i++) printf("\t%g\t%g\n", ae[i], ke[i]);
      fflush(stdout);
    }
    if(!doubleMatch(ke[0], 0.036, 1.0E-10) || !doubleMatch(ae[0], 1.0, 1.0E-10)) return(102);
    if(!doubleMatch(ke[1], 0.09, 1.0E-10) || !doubleMatch(ae[1], 2.0, 1.0E-10)) return(103);
    if(!doubleMatch(ke[2], 0.0036, 1.0E-10) || !doubleMatch(ae[2], 10.0, 1.0E-10)) return(104);
    if(!doubleMatch(ke[3], 0.0, 1.0E-10) || !doubleMatch(ae[3], 0.0, 1.0E-10)) return(105);

    if((ne=spectralBFExtract(k, a, n, ke, ae, 2))!=2) return(111);
    if(verbose>2) {
      printf("\n -> clusters:\n\tA\tB\n");
      for(int i=0; i<ne; i++) printf("\t%g\t%g\n", ae[i], ke[i]);
      fflush(stdout);
    }
    if(!doubleMatch(ke[0], 0.072, 1.0E-10) || !doubleMatch(ae[0], 3.0, 1.0E-10)) return(112);
    if(!doubleMatch(ke[1], 0.0036, 1.0E-10) || !doubleMatch(ae[1], 10.0, 1.0E-10)) return(113);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  {
    int n=20; double a[n], k[n], ae[n], ke[n];
    a[ 0]=0.0; k[ 0]=0.01;
    a[ 1]=9.0; k[ 1]=0.02;
    a[ 2]=1.0; k[ 2]=0.03;
    a[ 3]=0.0; k[ 3]=0.04;
    a[ 4]=0.0; k[ 4]=0.05;
    a[ 5]=1.0; k[ 5]=0.06;
    a[ 6]=2.0; k[ 6]=0.07;
    a[ 7]=1.0; k[ 7]=0.08;
    a[ 8]=0.0; k[ 8]=0.09;
    a[ 9]=0.1; k[ 9]=0.10;
    a[10]=0.2; k[10]=0.11;
    a[11]=0.1; k[11]=0.12;
    a[12]=0.0; k[12]=0.13;
    a[13]=0.0; k[13]=0.14;
    a[14]=0.0; k[14]=0.15;
    a[15]=1.0; k[15]=0.16;
    a[16]=1.0; k[16]=0.17;
    a[17]=1.0; k[17]=0.18;
    a[18]=0.0; k[18]=0.19;
    a[19]=0.0; k[19]=0.20;
    if(verbose>2) {
      printf("\nOriginal data:\n\tA\tB\n");
      for(int i=0; i<n; i++) printf("\t%g\t%g\n", a[i], k[i]);
      fflush(stdout);
    }
    int ne;
    if((ne=spectralBFExtract(k, a, n, ke, ae, 5))!=4) return(201);
    if(verbose>2) {
      printf("\n -> clusters:\n\tA\tB\n");
      for(int i=0; i<ne; i++) printf("\t%g\t%g\n", ae[i], ke[i]);
      fflush(stdout);
    }
    if(!doubleMatch(ke[0], 0.021, 1.0E-10) || !doubleMatch(ae[0], 10.0, 1.0E-10)) return(202);
    if(!doubleMatch(ke[1], 0.07, 1.0E-10) || !doubleMatch(ae[1], 4.0, 1.0E-10)) return(203);
    if(!doubleMatch(ke[2], 0.11, 1.0E-10) || !doubleMatch(ae[2], 0.4, 1.0E-10)) return(204);
    if(!doubleMatch(ke[3], 0.17, 1.0E-10) || !doubleMatch(ae[3], 3.0, 1.0E-10)) return(205);
    if(!doubleMatch(ke[4], 0.0, 1.0E-10) || !doubleMatch(ae[4], 0.0, 1.0E-10)) return(206);

    if((ne=spectralBFExtract(k, a, n, ke, ae, 3))!=3) return(211);
    if(verbose>2) {
      printf("\n -> clusters:\n\tA\tB\n");
      for(int i=0; i<ne; i++) printf("\t%g\t%g\n", ae[i], ke[i]);
      fflush(stdout);
    }
    if(!doubleMatch(ke[0], 0.021, 1.0E-10) || !doubleMatch(ae[0], 10.0, 1.0E-10)) return(212);
    if(!doubleMatch(ke[1], 0.07, 1.0E-10) || !doubleMatch(ae[1], 4.0, 1.0E-10)) return(213);
    if(!doubleMatch(ke[2], 0.162941176, 1.0E-08) || !doubleMatch(ae[2], 3.4, 1.0E-10)) return(214);

    if((ne=spectralBFExtract(k, a, n, ke, ae, 2))!=2) return(221);
    if(verbose>2) {
      printf("\n -> clusters:\n\tA\tB\n");
      for(int i=0; i<ne; i++) printf("\t%g\t%g\n", ae[i], ke[i]);
      fflush(stdout);
    }
    if(!doubleMatch(ke[0], 0.021, 1.0E-10) || !doubleMatch(ae[0], 10.0, 1.0E-10)) return(222);
    if(!doubleMatch(ke[1], 0.112702703, 1.0E-08) || !doubleMatch(ae[1], 7.4, 1.0E-10)) return(223);

    if((ne=spectralBFExtract(k, a, n, ke, ae, 1))!=1) return(231);
    if(verbose>2) {
      printf("\n -> clusters:\n\tA\tB\n");
      for(int i=0; i<ne; i++) printf("\t%g\t%g\n", ae[i], ke[i]);
      fflush(stdout);
    }
    if(!doubleMatch(ke[0], 0.06, 1.0E-10) || !doubleMatch(ae[0], 17.4, 1.0E-10)) return(232);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
