/** @file tpcbfm.h
 *  @brief Header file for libtpcbfm.
 *  @details Header file for template library libtpcbfm.
 *  @author Vesa Oikonen
 *  @copyright (c) Turku PET Centre
 */
#ifndef _TPCBFM_H_
#define _TPCBFM_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpccm.h"
#include "tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
/* bf_dexp */
int spectralDExp(
  const double *x, const double *y, double *w, const int snr,
  const double kmin, const double kmax, const int bnr,
  double *k, double *a, double *yfit,
  TPCSTATUS *status
);
int spectralKRange(
  double *k, double *a, const int n, double *kmin, double *kmax,
  TPCSTATUS *status
);
int spectralBFNr(double *k, double *a, const int n);
int spectralBFExtract(double *k, double *a, const int n, double *ke, double *ae, const int ne);
/*****************************************************************************/

/*****************************************************************************/
/* bf_radiowater */
int bfmRadiowater(
  TAC *input, TAC *tissue, const int bfNr, const double k2min,
  const double k2max, TAC *bf, TPCSTATUS *status
);
/*****************************************************************************/

/*****************************************************************************/
/* bf_srtm */
int bfmSRTM(
  double *t, double *cri, const int n, const int bfNr,
  const double t3min, const double t3max, TAC *bf,
  TPCSTATUS *status
);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TPCBFM */
