/******************************************************************************
 * This file is not compiled into the library, but it contains main()
 * which is compiled to an executable, used to test the library functions. 
 *****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/
#include "tpccm.h"
#include "test_tpccm.h"
/*****************************************************************************/

/*****************************************************************************/
static char *info[] = {
  "Usage: @P [options]",
  " ",
  "Options:",
  " -stdoptions", // List standard options like --help, -v, etc
  " -t, --test",
  "     Run all tests for library functions.",
  0};
/*****************************************************************************/

/*****************************************************************************/
/** Run unit tests to the library functions
    @author Vesa Oikonen
    @return 0 if all tests pass, otherwise >0.
 */
int main(
  /** Nr of arguments. */
  int argc,
  /** Pointer to arrays of argument string. */
  char *argv[ ]
) {
  int i, help=0, version=0, verbose=1, error=0, test=0;
  int ret;
  char *cptr;

  if(argc==1) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  for(i=1; i<argc; i++) {
    if(tpcProcessStdOptions(argv[i], &help, &version, &verbose)==0) continue;
    cptr=argv[i]; if(*cptr=='-') cptr++; if(*cptr=='-') cptr++;
    if(strncasecmp(cptr, "TEST", 1)==0) {
      test=1; continue;
    } else {
      error++; break;
    }
  }
  if(error>0) {
    fprintf(stderr, "Error: specify --help for usage.\n");
    return(1);
  }
  /* Print help or version? */
  if(help) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  if(version) {tpcPrintBuild(argv[0], stdout); return(0);}

  if(test==0) return(0);

  if(verbose>0) printf("running tests for library functions...\n");
  TPCSTATUS status; statusInit(&status); status.verbose=verbose;
  statusSet(&status, __func__, __FILE__, __LINE__, 0);
  i=10;
  /* sim1cm */
  i++; if((ret=test_simMBF(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC1(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC1_i(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* sim2cm */
  i++; if((ret=test_simC2(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC2_i(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* sim3cms */
  i++; if((ret=test_simC3s(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC3vs(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* sim3cmp */
  i++; if((ret=test_simC3p(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC3vp(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* simkloss */
  i++; if((ret=test_simC2l(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC2vl(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC3vpKLoss(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* simrtcm */
  i++; if((ret=test_simRTCM(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simSRTM(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simTRTM(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* simdicm */
  i++; if((ret=test_simC1DI(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC3DIvs(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC4DIvp(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simC4DIvs(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* simdispersion */
  i++; if((ret=test_simDispersion(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_corDispersion(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simTTM(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simTTM_i(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* simoxygen */
  i++; if((ret=test_simOxygen(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* convolut */
  i++; if((ret=test_convolve1D(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simIsSteadyInterval(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* simblood */
  i++; if((ret=test_icmparcInit(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_icmparcAddMetabolites(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_icmparcAllocateTACs(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_icmparcFree(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_simBTAC(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  if(verbose>0) printf("\nAll tests passed.\n\n");
  statusFree(&status);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
