/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpccm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_icmparcInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  icmparcInit(NULL);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}

  ICMPARC p;

  if(verbose>1) {printf("\ntry with correct input...\n"); fflush(stdout);}
  icmparcInit(&p);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}
  if(verbose>1) {printf("\nfree memory...\n"); fflush(stdout);}
  icmparcFree(&p);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_icmparcAddMetabolites(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  icmparcAddMetabolites(NULL, 2);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}

  ICMPARC p; icmparcInit(&p);

  if(verbose>1) {printf("\ntry with correct input...\n"); fflush(stdout);}
  if(icmparcAddMetabolites(&p, 2)!=0) return(1);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}
  if(p.mNr!=2 || p.metabolite==NULL) {icmparcFree(&p); return(2);}

  if(verbose>1) {printf("\nDelete metabolites...\n"); fflush(stdout);}
  if(icmparcAddMetabolites(&p, 0)!=0) return(3);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}
  if(p.mNr!=0 || p.metabolite!=NULL) {icmparcFree(&p); return(4);}

  icmparcFree(&p);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_icmparcAllocateTACs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  icmparcAllocateTACs(NULL, 0, 0);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}

  ICMPARC p; icmparcInit(&p);
  int ret;

  if(verbose>1) {printf("\ntry with correct input...\n"); fflush(stdout);}
  ret=icmparcAllocateTACs(&p, 20, 0);
  if(ret) {icmparcFree(&p); return(11);}
  if(p.ic_BV==NULL) {icmparcFree(&p); return(12);}
  if(verbose>1) {printf("\n Free allocated memory...\n"); fflush(stdout);}
  ret=icmparcAllocateTACs(&p, 0, 0);
  if(ret) {icmparcFree(&p); return(13);}
  if(p.ic_BV!=NULL) {icmparcFree(&p); return(14);}
  icmparcFree(&p);

  if(verbose>1) {printf("\ntry with sub-structures...\n"); fflush(stdout);}
  if(icmparcAddMetabolites(&p, 2)!=0) return(20);
  ret=icmparcAllocateTACs(&p, 20, 1);
  if(ret) {icmparcFree(&p); return(21);}
  if(p.ic_BV==NULL) {icmparcFree(&p); return(22);}
  if(p.metabolite[1].c_BA==NULL) {icmparcFree(&p); return(23);}
  if(verbose>1) {printf("\n Free allocated memory...\n"); fflush(stdout);}
  ret=icmparcAllocateTACs(&p, 0, 1);
  if(ret) {icmparcFree(&p); return(24);}
  if(p.ic_BV!=NULL) {icmparcFree(&p); return(25);}
  if(p.metabolite[1].c_BA!=NULL) {icmparcFree(&p); return(26);}
  icmparcFree(&p);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_icmparcFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  icmparcFree(NULL);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}

  ICMPARC p; icmparcInit(&p);

  if(verbose>1) {printf("\ntry with correct but empty input...\n"); fflush(stdout);}
  icmparcFree(&p);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) {printf("\ntry with contents...\n"); fflush(stdout);}
  if(icmparcAddMetabolites(&p, 2)!=0) return(1);
  icmparcFree(&p);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_simBTAC(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  if(simBTAC(NULL, 0, NULL, NULL)==0) return(1);
  if(verbose>2) {printf("  did not crash, good.\n"); fflush(stdout);}


  /* Make a set of parameters with just one compound, one tissue, and no efflux from system */
  /* Test with late time arterial/venous ratio, calculated from differential equation when dCa=0 */
  ICMPARC parent; icmparcInit(&parent);
  strcpy(parent.name, "parent");
  parent.Ti=1.0;
  parent.Tdur=10.0;
  parent.Irate=100.0;
  parent.k_BV_BA=1.0;
  parent.k_BA_U=0.0;
  parent.k_BA_TF=0.5;
  parent.k_TF_BV=0.5;
  parent.k_BA_TS=0.0;
  parent.k_TS_BV=0.0;
  parent.mNr=0;
  if(verbose>1) {printf("\ntry with invalid input...\n"); fflush(stdout);}
  if(simBTAC(NULL, 0, &parent, NULL)==0) return(10);
  if(verbose>1) {printf("\ntry with valid input...\n"); fflush(stdout);}
  unsigned int nr=100;
  double d[2*nr];
  for(unsigned int i=0; i<nr; i++) d[i]=0.5+(double)i;
  if(icmparcAllocateTACs(&parent, nr, 0)!=0) {icmparcFree(&parent); return(10);}
/*
  parent.c_BV=(double*)malloc(nr*sizeof(double));
  parent.c_TS=(double*)malloc(nr*sizeof(double));
  parent.c_TF=(double*)malloc(nr*sizeof(double));
*/
  if(simBTAC(d, nr, &parent, d+nr)!=0) {icmparcFree(&parent); return(11);}
  if(verbose>10) {
    for(unsigned int i=0; i<nr; i++)
      printf("\t%g\t%g\t%g\t%g\t%g\n", d[i], d[nr+i], parent.c_BV[i], parent.c_TS[i], parent.c_TF[i]);
    fflush(stdout);
  }
  if(!doubleMatch(d[2*nr-1]/parent.c_BV[nr-1], 2.0, 0.01)) {icmparcFree(&parent); return(12);}

  /* Add second tissue and efflux from system */
  if(verbose>1) {printf("\ntry with 2nd tissue and efflux\n"); fflush(stdout);}
  parent.k_BA_U=0.01;
  parent.k_BA_TS=0.2;
  parent.k_TS_BV=0.4;
  if(simBTAC(d, nr, &parent, d+nr)!=0) {icmparcFree(&parent); return(13);}
  if(verbose>10) {
    for(unsigned int i=0; i<nr; i++)
      printf("\t%g\t%g\t%g\t%g\t%g\n", d[i], d[nr+i], parent.c_BV[i], parent.c_TS[i], parent.c_TF[i]);
    fflush(stdout);
  }
  if(!doubleMatch(d[2*nr-1]/parent.c_BV[nr-1], 1.408450704, 0.01)) {icmparcFree(&parent); return(14);}
  icmparcFree(&parent);


  /* Test with metabolite */
  if(verbose>1) {printf("\ntry with metabolite\n"); fflush(stdout);}
  strcpy(parent.name, "parent");
  parent.Ti=1.0;
  parent.Tdur=10.0;
  parent.Irate=100.0;
  parent.k_BV_BA=1.0;
  parent.k_BA_U=0.001;
  parent.k_BA_TF=0.799;
  parent.k_TF_BV=0.4;
  parent.k_BA_TS=0.2;
  parent.k_TS_BV=0.2;
  if(icmparcAddMetabolites(&parent, 1)!=0) {icmparcFree(&parent); return(21);}
  strcpy(parent.metabolite[0].name, "metabolite");
  parent.metabolite[0].kp_BV=0.0;
  parent.metabolite[0].kp_TF=0.0;
  parent.metabolite[0].kp_TS=0.01;
  parent.metabolite[0].k_BV_BA=1.0;
  parent.metabolite[0].k_BA_U=0.02;
  parent.metabolite[0].k_BA_TF=0.68;
  parent.metabolite[0].k_TF_BV=0.6;
  parent.metabolite[0].k_BA_TS=0.1;
  parent.metabolite[0].k_TS_BV=0.1;

  nr=300;
  double dd[nr];
  for(unsigned int i=0; i<nr; i++) dd[i]=0.5+(double)i;
  if(icmparcAllocateTACs(&parent, nr, 1)!=0) {icmparcFree(&parent); return(22);}
/*
  parent.c_BA=(double*)malloc(nr*sizeof(double));
  parent.c_BV=(double*)malloc(nr*sizeof(double));
  parent.c_TS=(double*)malloc(nr*sizeof(double));
  parent.c_TF=(double*)malloc(nr*sizeof(double));
  parent.ic_BV=(double*)malloc(nr*sizeof(double));
  parent.ic_TS=(double*)malloc(nr*sizeof(double));
  parent.ic_TF=(double*)malloc(nr*sizeof(double));
  parent.metabolite[0].c_BA=(double*)malloc(nr*sizeof(double));
  parent.metabolite[0].c_BV=(double*)malloc(nr*sizeof(double));
  parent.metabolite[0].c_TS=(double*)malloc(nr*sizeof(double));
  parent.metabolite[0].c_TF=(double*)malloc(nr*sizeof(double));
*/
  if(verbose>1) {printf("\n  simulate parent\n"); fflush(stdout);}
  if(simBTAC(dd, nr, &parent, NULL)!=0) {icmparcFree(&parent); return(23);}
  if(verbose>10) {
    for(unsigned int i=0; i<nr; i++)
      printf("\t%g\t%g\t%g\t%g\t%g\n", dd[i], parent.c_BA[i], parent.c_BV[i], parent.c_TS[i], parent.c_TF[i]);
    printf("\ta/v = %g\n", parent.c_BA[nr-1]/parent.c_BV[nr-1]);
    fflush(stdout);
  }
  if(!doubleMatch(parent.c_BA[nr-1]/parent.c_BV[nr-1], 1.0, 0.01)) {icmparcFree(&parent); return(24);}
  if(verbose>1) {printf("\n  simulate metabolite\n"); fflush(stdout);}
  if(simBTAC(dd, nr, &parent.metabolite[0], NULL)!=0) {icmparcFree(&parent); return(25);}
  if(verbose>10) {
    for(unsigned int i=0; i<nr; i++)
      printf("\t%g\t%g\t%g\t%g\t%g\n", dd[i], parent.metabolite[0].c_BA[i], 
         parent.metabolite[0].c_BV[i], parent.metabolite[0].c_TS[i], parent.metabolite[0].c_TF[i]);
    printf("\ta/v = %g\n", parent.metabolite[0].c_BA[nr-1]/parent.metabolite[0].c_BV[nr-1]);
    fflush(stdout);
  }
  if(!doubleMatch(parent.metabolite[0].c_BA[nr-1]/parent.metabolite[0].c_BV[nr-1], 1.25, 0.01)) {
    icmparcFree(&parent); return(26);}
  icmparcFree(&parent);



  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
