/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpccsv.h"
/*****************************************************************************/

/*****************************************************************************/
int test_csvFindField(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i, n;
  CSV csv; csvInit(&csv);

  if(verbose>1) printf("testing with empty input\n");
  i=csvFindField(&csv, NULL, 0); if(i>=0) return 1;
  i=csvFindField(&csv, "", 0); if(i>=0) return 2;
  i=csvFindField(&csv, "", -1); if(i>=0) return 3;
  i=csvFindField(&csv, "", 100); if(i>=0) return 4;
  i=csvFindField(&csv, "ach", 0); if(i>=0) return 5;

  if(verbose>1) printf("making CSV contents for testing\n");
  csvPutString(&csv, "eka", 0);
  csvPutString(&csv, "toka", 0);
  csvPutString(&csv, "kolmas", 0);
  csvPutString(&csv, "", 1);
  csvPutString(&csv, "r2c2", 0);
  csvPutString(&csv, "r2c3", 0);
  csvPutString(&csv, "r3c1", 1);
  csvPutString(&csv, "r3c2", 0);
  csvPutString(&csv, "r3c3", 0);
  csvPutString(&csv, "sama", 1);
  csvPutString(&csv, "sama", 0);
  csvPutString(&csv, "sama", 0);

  if(verbose>1) printf("testing with filled input\n");
  i=csvFindField(&csv, NULL, 0); if(i>=0) {csvFree(&csv); return 11;}
  i=csvFindField(&csv, "", 0); if(i!=3) {csvFree(&csv); return 12;}
  i=csvFindField(&csv, "", -1); if(i>=0) {csvFree(&csv); return 13;}
  i=csvFindField(&csv, "", 100); if(i>=0) {csvFree(&csv); return 14;}
  i=csvFindField(&csv, "ach", 0); if(i>=0) {csvFree(&csv); return 15;}

  i=csvFindField(&csv, "eka", 0); if(i!=0) {csvFree(&csv); return 21;}
  i=csvFindField(&csv, "Eka", 0); if(i!=0) {csvFree(&csv); return 22;}
  i=csvFindField(&csv, "eka", 1); if(i>=0) {csvFree(&csv); return 23;}
  i=csvFindField(&csv, "ek", 0); if(i>=0) {csvFree(&csv); return 24;}

  i=n=0; while((i=csvFindField(&csv, "sama", i))>=0) {
    i++; n++;
  }
  if(n!=3) {csvFree(&csv); return 31;}


  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvSearchField(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i, n;
  CSV csv; csvInit(&csv);

  if(verbose>1) printf("testing with empty input\n");
  i=csvSearchField(&csv, NULL, 0); if(i>=0) return 1;
  i=csvSearchField(&csv, "", 0); if(i>=0) return 2;
  i=csvSearchField(&csv, "", -1); if(i>=0) return 3;
  i=csvSearchField(&csv, "", 100); if(i>=0) return 4;
  i=csvSearchField(&csv, "ach", 0); if(i>=0) return 5;


  if(verbose>1) printf("making CSV contents for testing\n");
  csvPutString(&csv, "eka", 0);
  csvPutString(&csv, "toka", 0);
  csvPutString(&csv, "kolmas", 0);
  csvPutString(&csv, "", 1);
  csvPutString(&csv, "r2c2", 0);
  csvPutString(&csv, "r2c3", 0);
  csvPutString(&csv, "r3c1", 1);
  csvPutString(&csv, "r3c2", 0);
  csvPutString(&csv, "r3c3", 0);
  csvPutString(&csv, "sama", 1);
  csvPutString(&csv, "sama", 0);
  csvPutString(&csv, "sama", 0);
  if(verbose>3) csvWrite(&csv, 0, stdout, NULL);

  if(verbose>1) printf("testing with filled input\n");
  i=csvSearchField(&csv, NULL, 0); if(i>=0) {csvFree(&csv); return 11;}
  i=csvSearchField(&csv, "", 0); if(i!=3) {csvFree(&csv); return 12;}
  i=csvSearchField(&csv, "", -1); if(i>=0) {csvFree(&csv); return 13;}
  i=csvSearchField(&csv, "", 100); if(i>=0) {csvFree(&csv); return 14;}
  i=csvSearchField(&csv, "ach", 0); if(i>=0) {csvFree(&csv); return 15;}

  i=csvSearchField(&csv, "eka", 0); if(i!=0) {csvFree(&csv); return 21;}
  i=csvSearchField(&csv, "Eka", 0); if(i!=0) {csvFree(&csv); return 22;}
  i=csvSearchField(&csv, "eka", 1); if(i>=0) {csvFree(&csv); return 23;}
  i=csvSearchField(&csv, "ek", 0); if(i!=0) {csvFree(&csv); return 24;}

  i=n=0; while((i=csvSearchField(&csv, "ma", i))>=0) {i++; n++;}
  if(n!=4) {csvFree(&csv); return 31;}
  i=n=0; while((i=csvSearchField(&csv, "2", i))>=0) {i++; n++;}
  if(n!=3) {csvFree(&csv); return 32;}
  i=n=0; while((i=csvSearchField(&csv, "3", i))>=0) {i++; n++;}
  if(n!=4) {csvFree(&csv); return 33;}


  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
