/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcdcm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_dcmImgIsotope(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmImgIsotope(NULL, NULL, NULL, verbose-1)==0) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  decaycorrection dc;
  isotope isot;

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmImgIsotope(NULL, &isot, &dc, verbose-1)==0) return(2);
  if(verbose>2) printf("  did not crash, good.\n");
  if(isot!=ISOTOPE_UNKNOWN || dc!=DECAY_UNKNOWN) return(3);

  if(verbose>1) printf("\ntry with an Inveon DICOM file...\n");
  int ret;
  char fname[256];
  DCMFILE dcm; dcmfileInit(&dcm);
  strcpy(fname, "f170.dcm");
  if(verbose>3) ret=dcmFileRead(fname, &dcm, 0, status);
  else ret=dcmFileRead(fname, &dcm, 0, NULL);
  if(ret!=0) return(11);

  if(dcmImgIsotope(&dcm, &isot, &dc, verbose-1)!=0) {dcmfileFree(&dcm); return(12);}
  if(verbose>2) {
    printf("  -> isotope := %s\n", isotopeName(isot));
    printf("  -> dc := %s\n", decayDescr(dc));
  }
  if(isot!=ISOTOPE_F_18) {dcmfileFree(&dcm); return(13);}
  if(dc!=DECAY_CORRECTED_START) {dcmfileFree(&dcm); return(14);}

  if(verbose>1) printf("\nasking only for status of decay correction...\n");
  if(dcmImgIsotope(&dcm, NULL, &dc, verbose-1)!=0) {dcmfileFree(&dcm); return(15);}
  if(verbose>2) {
    printf("  -> dc := %s\n", decayDescr(dc));
  }
  if(dc!=DECAY_CORRECTED_START) {dcmfileFree(&dcm); return(16);}

  if(verbose>1) printf("\nasking only for the isotope...\n");
  if(dcmImgIsotope(&dcm, &isot, NULL, verbose-1)!=0) {dcmfileFree(&dcm); return(17);}
  if(verbose>2) {
    printf("  -> isotope := %s\n", isotopeName(isot));
  }
  if(isot!=ISOTOPE_F_18) {dcmfileFree(&dcm); return(18);}


  dcmfileFree(&dcm);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmImgPos(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmImgPos(NULL, NULL, verbose-1)==0) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  DCMFILE dcm; dcmfileInit(&dcm);
  double imgpos[3];

  if(verbose>1) printf("\nTrying with empty input...\n");
  if(dcmImgPos(&dcm, imgpos, verbose-1)==0) return(2);
  if(verbose>2) printf("  did not crash, good.\n");

  int ret;
  char fname[256];

  if(verbose>1) printf("\ntry with an Inveon DICOM file...\n");
  strcpy(fname, "f170.dcm");
  if(verbose>3) ret=dcmFileRead(fname, &dcm, 0, status);
  else ret=dcmFileRead(fname, &dcm, 0, NULL);
  if(ret!=0) return(11);
  ret=dcmImgPos(&dcm, imgpos, verbose-1);
  if(ret!=0) {
    if(verbose>2) printf("  ret := %d\n", ret);
    dcmfileFree(&dcm); return(12);
  }
  if(verbose>3) {
    printf("  imgpos := %g", imgpos[0]); for(int i=1; i<3; i++) printf(", %g", imgpos[i]); 
    printf("\n");
  }
  if(!doubleMatch(49.3, imgpos[0], 0.01) || !doubleMatch(49.3, imgpos[1], 0.01) ||
     !doubleMatch(54.924, imgpos[2], 0.01))
  {
    dcmfileFree(&dcm); return(13);
  }


  dcmfileFree(&dcm);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmImgDim(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmImgDim(NULL, NULL, verbose-1)==0) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  DCMFILE dcm; dcmfileInit(&dcm);
  unsigned short int imgdim[4];

  if(verbose>1) printf("\nTrying with empty input...\n");
  if(dcmImgDim(&dcm, imgdim, verbose-1)==0) return(2);
  if(verbose>2) printf("  did not crash, good.\n");

  int ret;
  char fname[256];

  if(verbose>1) printf("\ntry with an Inveon DICOM file...\n");
  strcpy(fname, "f170.dcm");
  if(verbose>3) ret=dcmFileRead(fname, &dcm, 0, status);
  else ret=dcmFileRead(fname, &dcm, 0, NULL);
  if(ret!=0) return(11);
  ret=dcmImgDim(&dcm, imgdim, verbose-1);
  if(ret!=0) {
    if(verbose>2) printf("  ret := %d\n", ret);
    dcmfileFree(&dcm); return(12);
  }
  if(verbose>3) {
    printf("  imgdim := %u", imgdim[0]); for(int i=1; i<4; i++) printf(", %u", imgdim[i]); 
    printf("\n");
  }
  if(imgdim[0]!=128 || imgdim[1]!=128 || imgdim[2]!=159 || imgdim[3]!=24) {
    dcmfileFree(&dcm); return(13);
  }

  dcmfileFree(&dcm);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmImgPxlsize(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmImgPxlsize(NULL, NULL, verbose-1)==0) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  DCMFILE dcm; dcmfileInit(&dcm);
  double pxlsize[3];

  if(verbose>1) printf("\nTrying with empty input...\n");
  if(dcmImgPxlsize(&dcm, pxlsize, verbose-1)==0) return(2);
  if(verbose>2) printf("  did not crash, good.\n");

  int ret;
  char fname[256];

  if(verbose>1) printf("\ntry with an Inveon DICOM file...\n");
  strcpy(fname, "f170.dcm");
  if(verbose>3) ret=dcmFileRead(fname, &dcm, 0, status);
  else ret=dcmFileRead(fname, &dcm, 0, NULL);
  if(ret!=0) return(11);
  ret=dcmImgPxlsize(&dcm, pxlsize, verbose-1);
  if(ret!=0) {
    if(verbose>2) printf("  ret := %d\n", ret);
    dcmfileFree(&dcm); return(12);
  }
  if(verbose>3) {
    printf("  pxlsize := %g", pxlsize[0]); for(int i=1; i<3; i++) printf(", %g", pxlsize[i]); 
    printf("\n");
  }
  if(!doubleMatch(0.776383, pxlsize[0], 0.0001) || !doubleMatch(0.776383, pxlsize[1], 0.0001) ||
     !doubleMatch(0.796, pxlsize[2], 0.001))
  {
    dcmfileFree(&dcm); return(13);
  }


  dcmfileFree(&dcm);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmImgOrient(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmImgOrient(NULL, NULL, verbose-1)==0) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  DCMFILE dcm; dcmfileInit(&dcm);
  double iop[6];

  if(verbose>1) printf("\nTrying with empty input...\n");
  if(dcmImgOrient(&dcm, iop, verbose-1)==0) return(2);
  if(verbose>2) printf("  did not crash, good.\n");

  int ret;
  char fname[256];

  if(verbose>1) printf("\ntry with an Inveon DICOM file...\n");
  strcpy(fname, "f170.dcm");
  if(verbose>3) ret=dcmFileRead(fname, &dcm, 0, status);
  else ret=dcmFileRead(fname, &dcm, 0, NULL);
  if(ret!=0) return(11);
  ret=dcmImgOrient(&dcm, iop, verbose-1);
  if(ret!=0) {
    if(verbose>2) printf("  ret := %d\n", ret);
    dcmfileFree(&dcm); return(12);
  }
  if(verbose>3) {
    printf("  iop := %g", iop[0]); for(int i=1; i<6; i++) printf(", %g", iop[i]); 
    printf("\n");
  }
  if(!doubleMatch(-1.0, iop[0], 0.001) || !doubleMatch(0.0, iop[1], 0.001) ||
     !doubleMatch(0.0, iop[2], 0.001))
  {
    dcmfileFree(&dcm); return(13);
  }
  if(!doubleMatch(0.0, iop[3], 0.001) || !doubleMatch(-1.0, iop[4], 0.001) ||
     !doubleMatch(0.0, iop[5], 0.001))
  {
    dcmfileFree(&dcm); return(14);
  }


  dcmfileFree(&dcm);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmImgXform(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmImgXform(NULL, NULL, NULL, NULL, verbose-1)==0) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  double iop[6], xyzMM[3], ipp[3], xform[16];

  if(verbose>1) printf("\nTrying with zero input...\n");
  for(int i=0; i<6; i++) iop[i]=0.0;
  for(int i=0; i<3; i++) xyzMM[i]=0.0;
  for(int i=0; i<3; i++) ipp[i]=0.0;
  if(dcmImgXform(iop, xyzMM, ipp, xform, verbose-1)!=0) return(2);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\nTrying with NaN input...\n");
  for(int i=0; i<6; i++) iop[i]=nan("");
  for(int i=0; i<3; i++) xyzMM[i]=nan("");
  for(int i=0; i<3; i++) ipp[i]=nan("");
  if(dcmImgXform(iop, xyzMM, ipp, xform, verbose-1)!=0) return(3);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\nTrying with true input...\n");
  iop[0]=1.0; iop[1]=0.0; iop[2]=0.0; iop[3]=0.0; iop[4]=1.0; iop[5]=-0.0;
  xyzMM[0]=3.6458332538605; xyzMM[1]=3.6458332538605; xyzMM[2]=3.2700;
  ipp[0]=-348.17709350585; ipp[1]=-348.17709350585; ipp[2]=-135.250;
  if(dcmImgXform(iop, xyzMM, ipp, xform, verbose-1)!=0) return(11);
  if(verbose>2) for(int i=0; i<4; i++) {
    printf("%g", xform[4*i]);
    for(int j=1; j<4; j++) printf("\t%g", xform[j+4*i]);
    printf("\n");
  }
  if(!doubleMatch(3.64583, xform[0], 0.001)) return(12);
  if(!doubleMatch(0.0,     xform[1], 0.001)) return(12);
  if(!doubleMatch(0.0,     xform[2], 0.001)) return(12);
  if(!doubleMatch(0.0,     xform[4], 0.001)) return(12);
  if(!doubleMatch(3.64583, xform[5], 0.001)) return(12);
  if(!doubleMatch(0.0,     xform[6], 0.001)) return(12);
  if(!doubleMatch(0.0,     xform[8], 0.001)) return(12);
  if(!doubleMatch(0.0,     xform[9], 0.001)) return(12);
  if(!doubleMatch(3.27,    xform[10], 0.001)) return(12);

  if(!doubleMatch(-348.177, xform[3], 0.01)) return(13);
  if(!doubleMatch(-348.177, xform[7], 0.01)) return(13);
  if(!doubleMatch(-135.25,  xform[11], 0.01)) return(13);

  /* More tests with application dcmxform */

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmXformToQuatern(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
    fflush(stdout);
  }

  if(verbose>1) printf("\nTrying with NULL input...\n");
  if(dcmXformToQuatern(NULL, NULL, NULL, verbose-1)==0) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  double quatern[6], xform[16];

  if(verbose>1) printf("\nTrying with zero input...\n");
  for(int i=0; i<16; i++) xform[i]=0.0;
  if(dcmXformToQuatern(xform, quatern+0, quatern+3, verbose-1)!=0) return(2);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\nTrying with NaN input...\n");
  for(int i=0; i<16; i++) xform[i]=nan("");
  if(dcmXformToQuatern(xform, quatern+0, quatern+3, verbose-1)!=0) return(3);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\nTrying with true input...\n");
  double iop[6], xyzMM[3], ipp[3];
  iop[0]=1.0; iop[1]=0.0; iop[2]=0.0; iop[3]=0.0; iop[4]=1.0; iop[5]=-0.0;
  xyzMM[0]=3.6458332538605; xyzMM[1]=3.6458332538605; xyzMM[2]=3.2700;
  ipp[0]=-348.17709350585; ipp[1]=-348.17709350585; ipp[2]=-135.250;
  if(dcmImgXform(iop, xyzMM, ipp, xform, verbose-1)!=0) return(11);
  if(verbose>2) for(int i=0; i<4; i++) {
    printf("%g", xform[4*i]);
    for(int j=1; j<4; j++) printf("\t%g", xform[j+4*i]);
    printf("\n");
  }
  if(dcmXformToQuatern(xform, quatern+0, quatern+3, verbose-1)!=0) return(12);
  /* TPC ImageConverter calculated these quatern parameters;
     note that dcm2niix gives different orientation. */
  if(!doubleMatch(0.0, quatern[0], 0.001)) return(13);
  if(!doubleMatch(0.0, quatern[1], 0.001)) return(13);
  if(!doubleMatch(1.0, quatern[2], 0.001)) return(13);
  if(!doubleMatch(+348.177, quatern[3], 0.001)) return(14);
  if(!doubleMatch(+348.177, quatern[4], 0.001)) return(14);
  if(!doubleMatch(-135.25,  quatern[5], 0.001)) return(14);

  /* More tests with application dcmxform */

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
