/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcecat.h"
/*****************************************************************************/

/*****************************************************************************/
int test_ecatWriteMainheader(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift; iftInit(&ift);
  int ret;
  unsigned char buf[ECATBLKSIZE];

  if(verbose>1) printf("\ntry with NULL input...\n");

  ret=ecatWriteMainheader(NULL, NULL, NULL);
  if(ret==TPCERROR_OK) return(1);

  if(verbose>1) printf("\ntry with empty input...\n");
  ret=ecatWriteMainheader(&ift, buf, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n Set IFT contents \n");
  iftPut(&ift, "magic_number", "MATRIX72v", 0, NULL);
  iftPut(&ift, "original_file_name", "test", 0, NULL);

  if(verbose>1) printf("\n Make header block \n");
  ret=ecatWriteMainheader(&ift, buf, NULL);
  iftFree(&ift);
  if(ret!=TPCERROR_OK) return(11);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_ecatReadMainheader(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift; iftInit(&ift);
  int ret;
  unsigned char buf[ECATBLKSIZE];

  if(verbose>1) printf("\ntry with NULL input...\n");

  ret=ecatReadMainheader(NULL, NULL, NULL);
  if(ret==TPCERROR_OK) return(1);

  if(verbose>1) printf("\ntry with empty input...\n");
  ret=ecatReadMainheader(buf, &ift, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
// Does not yet identify error
//  if(ret==TPCERROR_OK) return(2);
  iftFree(&ift);

  if(verbose>1) {printf("\n Set IFT contents \n"); fflush(stdout);}
  iftPut(&ift, "magic_number", "MATRIX72v", 0, NULL);
  iftPut(&ift, "original_file_name", "test", 0, NULL);

  if(verbose>1) {printf("\n Make header block \n"); fflush(stdout);}
  ret=ecatWriteMainheader(&ift, buf, NULL);
  if(verbose>3) {iftWrite(&ift, stdout, NULL); fflush(stdout);}
  iftFree(&ift); if(ret!=TPCERROR_OK) return(10);

  if(verbose>1) {printf("\n Read header block \n"); fflush(stdout);}
  ret=ecatReadMainheader(buf, &ift, NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift); return(11);}
  if(verbose>3) {iftWrite(&ift, stdout, NULL); fflush(stdout);}

  int ii=iftFindPair(&ift, "magic_number", "MATRIX72v", 0);
  if(ii<0) {iftFree(&ift); return(12);}

  iftFree(&ift);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
