/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcecat.h"
/*****************************************************************************/

/*****************************************************************************/
int test_ecatMListInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  ecatMListInit(NULL);
  if(verbose>2) {printf("\n did not crash, good\n"); fflush(stdout);}

  if(verbose>1) {printf("\ntry normal use...\n"); fflush(stdout);}
  ECAT_MATRIXLIST ml;
  ecatMListInit(&ml);
  if(verbose>2) {printf("\n did not crash, good\n"); fflush(stdout);}
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_ecatMListFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  ecatMListFree(NULL);
  if(verbose>2) {printf("\n did not crash, good\n"); fflush(stdout);}

  if(verbose>1) {printf("\ntry normal use...\n"); fflush(stdout);}
  ECAT_MATRIXLIST ml;
  ecatMListInit(&ml);
  ecatMListFree(&ml);
  if(verbose>2) {printf("\n did not crash, good\n"); fflush(stdout);}
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_ecatMListReadId(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  ecatMListReadId(0, 0, NULL);
  if(verbose>2) {printf("\n did not crash, good\n"); fflush(stdout);}
  ecatMListReadId(7, 0, NULL);
  if(verbose>2) {printf("\n did not crash, good\n"); fflush(stdout);}

  if(verbose>1) {printf("\ntry normal use...\n"); fflush(stdout);}
  ECAT_MATVAL mv;
  unsigned int matnum=0;
  ecatMListReadId(7, matnum, &mv);
  if(verbose>3) printf("ECAT7 %u -> %d %d %d %d %d\n", matnum, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(mv.frame!=0 || mv.plane!=0 || mv.gate!=0 || mv.data!=0 || mv.bed!=0) return(11);
  ecatMListReadId(6, matnum, &mv);
  if(verbose>3) printf("ECAT6 %u -> %d %d %d %d %d\n", matnum, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(mv.frame!=0 || mv.plane!=0 || mv.gate!=0 || mv.data!=0 || mv.bed!=0) return(12);
  
  matnum=1090588673;
  ecatMListReadId(7, matnum, &mv);
  if(verbose>3) printf("ECAT7 %u -> %d %d %d %d %d\n", matnum, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(mv.frame!=1 || mv.plane!=1 || mv.gate!=1 || mv.data!=1 || mv.bed!=1) return(21);
  ecatMListReadId(6, matnum, &mv);
  if(verbose>3) printf("ECAT6 %u -> %d %d %d %d %d\n", matnum, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(mv.frame!=1 || mv.plane!=1 || mv.gate!=1 || mv.data!=1 || mv.bed!=1) return(22);

  matnum=33490943;
  ecatMListReadId(7, matnum, &mv);
  if(verbose>3) printf("ECAT7 %u -> %d %d %d %d %d\n", matnum, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(mv.frame!=511 || mv.plane!=1023 || mv.gate!=1 || mv.data!=0 || mv.bed!=0) return(31);
  matnum=33492991;
  ecatMListReadId(6, matnum, &mv);
  if(verbose>3) printf("ECAT6 %u -> %d %d %d %d %d\n", matnum, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(mv.frame!=4095 || mv.plane!=255 || mv.gate!=1 || mv.data!=0 || mv.bed!=0) return(32);

  matnum=4294967295; // 2^32 - 1
  ecatMListReadId(7, matnum, &mv);
  if(verbose>3) printf("ECAT7 %u -> %d %d %d %d %d\n", matnum, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(mv.frame!=511 || mv.plane!=1023 || mv.gate!=63 || mv.data!=7 || mv.bed!=15) return(41);
  ecatMListReadId(6, matnum, &mv);
  if(verbose>3) printf("ECAT6 %u -> %d %d %d %d %d\n", matnum, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(mv.frame!=4095 || mv.plane!=255 || mv.gate!=63 || mv.data!=3 || mv.bed!=15) return(42);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_ecatMListMakeId(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int matnum;
  ECAT_MATVAL mv;

  mv.frame=0; mv.plane=0; mv.gate=0; mv.data=0; mv.bed=0;
  matnum=ecatMListMakeId(7, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(verbose>3) printf("%d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=0) return(11);
  matnum=ecatMListMakeId(6, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(verbose>3) printf("%d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=0) return(12);

  mv.frame=1; mv.plane=1; mv.gate=1; mv.data=1; mv.bed=1;
  matnum=ecatMListMakeId(7, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(verbose>3) printf("ECAT7 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=1090588673) return(21);
  matnum=ecatMListMakeId(6, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(verbose>3) printf("ECAT6 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=1090588673) return(22);

  mv.frame=511; mv.plane=1023; mv.gate=1; mv.data=0; mv.bed=0;
  matnum=ecatMListMakeId(7, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(verbose>3) printf("ECAT7 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=33490943) return(31);
  mv.frame=4095; mv.plane=255; mv.gate=1; mv.data=0; mv.bed=0;
  matnum=ecatMListMakeId(6, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(verbose>3) printf("ECAT6 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=33492991) return(32);

  mv.frame=511; mv.plane=1023; mv.gate=63; mv.data=7; mv.bed=15;
  matnum=ecatMListMakeId(7, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(verbose>3) printf("ECAT7 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=4294967295) return(41);
  mv.frame=4095; mv.plane=255; mv.gate=63; mv.data=3; mv.bed=15;
  matnum=ecatMListMakeId(6, mv.frame, mv.plane, mv.gate, mv.data, mv.bed);
  if(verbose>3) printf("ECAT6 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=4294967295) return(42);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_ecatMValToId(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int matnum;
  ECAT_MATVAL mv;

  mv.frame=0; mv.plane=0; mv.gate=0; mv.data=0; mv.bed=0;
  matnum=ecatMValToId(7, &mv);
  if(verbose>3) printf("%d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=0) return(11);
  matnum=ecatMValToId(6, &mv);
  if(verbose>3) printf("%d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=0) return(12);

  mv.frame=1; mv.plane=1; mv.gate=1; mv.data=1; mv.bed=1;
  matnum=ecatMValToId(7, &mv);
  if(verbose>3) printf("ECAT7 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=1090588673) return(21);
  matnum=ecatMValToId(6, &mv);
  if(verbose>3) printf("ECAT6 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=1090588673) return(22);

  mv.frame=511; mv.plane=1023; mv.gate=1; mv.data=0; mv.bed=0;
  matnum=ecatMValToId(7, &mv);
  if(verbose>3) printf("ECAT7 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=33490943) return(31);
  mv.frame=4095; mv.plane=255; mv.gate=1; mv.data=0; mv.bed=0;
  matnum=ecatMValToId(6, &mv);
  if(verbose>3) printf("ECAT6 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=33492991) return(32);

  mv.frame=511; mv.plane=1023; mv.gate=63; mv.data=7; mv.bed=15;
  matnum=ecatMValToId(7, &mv);
  if(verbose>3) printf("ECAT7 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=4294967295) return(41);
  mv.frame=4095; mv.plane=255; mv.gate=63; mv.data=3; mv.bed=15;
  matnum=ecatMValToId(6, &mv);
  if(verbose>3) printf("ECAT6 %d %d %d %d %d -> %u\n", mv.frame, mv.plane, mv.gate, mv.data, mv.bed, matnum);
  if(matnum!=4294967295) return(42);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_ecatMListRead(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char fname[256];
  int ret;

  if(verbose>1) {printf("\ntry with NULL input...\n"); fflush(stdout);}
  ret=ecatMListRead(7, NULL, NULL, NULL);
  if(verbose>2) {printf("\n did not crash, good\n"); fflush(stdout);}
  if(ret==TPCERROR_OK) return(1);

  if(verbose>1) {printf("\ntry normal use...\n"); fflush(stdout);}
  ECAT_MATRIXLIST ml;
  ecatMListInit(&ml);
  strcpy(fname, "ECAT6_square.img");
  FILE *fp=fopen(fname, "rb"); if(fp==NULL) return(11);
  ret=ecatMListRead(6, fp, &ml, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) return(12);
  if(verbose>2) printf("matrixNr := %u\n", ml.matrixNr);
  if(verbose>1) ecatMListPrint(6, &ml, stdout);
  if(ml.matrixNr!=35) {ecatMListFree(&ml); return(13);}
  ecatMListFree(&ml);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
