/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_filenameRmPath(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr, fname[256];

  cptr=NULL; filenameRmPath(cptr);

  strcpy(fname, ""); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "")!=0) return(1);

  strcpy(fname, "/usr/local/bin/foo");
  if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "foo")!=0) return(2);

  strcpy(fname, "/foo");
  if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "foo")!=0) return(3);

  strcpy(fname, "foo");
  if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "foo")!=0) return(4);

  strcpy(fname, "../foo"); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "foo")!=0) return(5);

  strcpy(fname, "../"); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "")!=0) return(6);

  strcpy(fname, "C:\\Program Files\\foo.exe");
  if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "foo.exe")!=0) return(12);

  strcpy(fname, "\\foo.exe"); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "foo.exe")!=0) return(13);

  strcpy(fname, "foo.exe"); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "foo.exe")!=0) return(14);

  strcpy(fname, "..\\foo.exe"); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "foo.exe")!=0) return(15);

  strcpy(fname, "..\\"); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmPath(fname);
  if(strcmp(fname, "")!=0) return(16);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_filenameRmFile(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr, fname[256];

  if(verbose>1) printf("\nTrying with NULL input\n");
  cptr=NULL; filenameRmFile(cptr);

  strcpy(fname, ""); 
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "")!=0) return(1);

  strcpy(fname, "/usr/local/bin/foo");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "/usr/local/bin")!=0) return(2);

  strcpy(fname, "/foo");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "")!=0) return(3);

  strcpy(fname, "foo");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, ".")!=0) return(4);

  strcpy(fname, "../foo");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "..")!=0) return(5);

  strcpy(fname, "../");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "..")!=0) return(6);

  strcpy(fname, "..");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "..")!=0) return(7);

  strcpy(fname, "./");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, ".")!=0) return(8);

  strcpy(fname, ".");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, ".")!=0) return(9);

  strcpy(fname, "a");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, ".")!=0) return(10);

  strcpy(fname, "C:\\Program Files\\foo.exe");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "C:\\Program Files")!=0) return(12);

  strcpy(fname, "\\foo.exe");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "")!=0) return(13);

  strcpy(fname, "foo.exe");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, ".")!=0) return(14);

  strcpy(fname, "..\\foo.exe");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "..")!=0) return(15);

  strcpy(fname, "..\\");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "..")!=0) return(16);

  strcpy(fname, "/");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "")!=0) return(21);

  strcpy(fname, "\\");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "")!=0) return(22);

  strcpy(fname, "//");
  if(verbose>1) printf("\nfname := '%s'\n", fname);
  filenameRmFile(fname); if(verbose>2) printf(" -> '%s'\n", fname);
  if(strcmp(fname, "")!=0) return(23);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_filenameRmExtension(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr, fname[256];

  cptr=NULL; if(filenameRmExtension(cptr)!=0) return(1);

  strcpy(fname, ""); if(verbose>1) printf("fname := '%s'\n", fname);
  if(filenameRmExtension(fname)!=0) return(2);
  if(strcmp(fname, "")!=0) return(2);

  strcpy(fname, "..\\foo.txt"); if(verbose>1) printf("fname := '%s'\n", fname);
  if(filenameRmExtension(fname)!=1) return(3);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "..\\foo")!=0) return(3);

  strcpy(fname, "..\\foo.txt.bak");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(filenameRmExtension(fname)!=1) return(4);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "..\\foo.txt")!=0) return(4);

  strcpy(fname, "..\\foo");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(filenameRmExtension(fname)!=0) return(5);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "..\\foo")!=0) return(5);

  strcpy(fname, "./foo");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(filenameRmExtension(fname)!=0) return(6);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "./foo")!=0) return(6);

  strcpy(fname, ".foo");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(filenameRmExtension(fname)!=1) return(7);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "")!=0) return(7);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_filenameRmExtensions(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr, fname[256];

  cptr=NULL; filenameRmExtensions(cptr);

  strcpy(fname, ""); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmExtensions(fname);
  if(strcmp(fname, "")!=0) return(2);

  strcpy(fname, "..\\foo.txt"); if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmExtensions(fname);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "..\\foo")!=0) return(3);

  strcpy(fname, "..\\foo.txt.bak");
  if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmExtensions(fname);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "..\\foo")!=0) return(4);

  strcpy(fname, "..\\foo");
  if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmExtensions(fname);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "..\\foo")!=0) return(5);

  strcpy(fname, "./foo");
  if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmExtensions(fname);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "./foo")!=0) return(6);

  strcpy(fname, "C:\\tmp\\.hidden.txt.bak");
  if(verbose>1) printf("fname := '%s'\n", fname);
  filenameRmExtensions(fname);
  if(verbose>2) printf("  -> fname := '%s'\n", fname);
  if(strcmp(fname, "C:\\tmp\\")!=0) return(7);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_fnmatch(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char key[256], fname[256];
  int ret;

  ret=fnmatch(NULL, NULL);
  if(ret!=0) return(1);

  strcpy(fname, ""); strcpy(key, "");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(2);

  strcpy(fname, "test.dat"); strcpy(key, "*.dat");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(3);

  strcpy(fname, "test.dat"); strcpy(key, "test.*");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(4);

  strcpy(fname, "test.dat"); strcpy(key, "*.*");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(5);

  strcpy(fname, "test.dat"); strcpy(key, "*");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(6);

  strcpy(fname, "datafile"); strcpy(key, "*file");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(7);

  strcpy(fname, "datafile"); strcpy(key, "data*");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(7);

  strcpy(fname, "test6.dat"); strcpy(key, "test?.dat");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(11);

  strcpy(fname, "test6.bak"); strcpy(key, "test?.*");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(12);

  strcpy(fname, "TEST.DAT"); strcpy(key, "test.*");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fnmatch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret!=0) return(21);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_fncasematch(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char key[256], fname[256];
  int ret;

  ret=fncasematch(NULL, NULL);
  if(ret!=0) return(1);

  strcpy(fname, ""); strcpy(key, "");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fncasematch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(2);

  strcpy(fname, "TEST.DAT"); strcpy(key, "*.dat");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fncasematch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(3);

  strcpy(fname, "TEST.DAT"); strcpy(key, "test.*");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fncasematch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(3);

  strcpy(fname, "test.dat"); strcpy(key, "*.DAT");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fncasematch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(4);

  strcpy(fname, "Test034.dat"); strcpy(key, "test???.dat");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fncasematch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret==0) return(11);

  strcpy(fname, "Test034.dat"); strcpy(key, "test1??.dat");
  if(verbose>1) printf("fname := '%s'\n", fname);
  if(verbose>1) printf("key := '%s'\n", key);
  ret=fncasematch(fname, key);
  if(verbose>2) {if(ret) printf("  -> match\n"); else printf("  -> no match\n");}
  if(ret!=0) return(12);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_filenameGetExtension(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr, fname[256];

  if(verbose>1) printf("empty string\n");
  cptr=NULL; if(filenameGetExtension(cptr)) return(1);
  strcpy(fname, "");
  if(filenameGetExtension(fname)) return(2);

  strcpy(fname, "file.txt");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(11);

  strcpy(fname, "path/file.txt");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(12);

  strcpy(fname, "path\\file.txt");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(13);

  strcpy(fname, "file.txt.bak");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".bak")) return(14);

  strcpy(fname, "C:\\temp\\Tampere 2014\\file.txt");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(15);

  strcpy(fname, "C:\\temp\\Tampere.2014\\file.txt");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(16);

  strcpy(fname, "image.v");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".v")) return(17);
  
  strcpy(fname, "filenamewithoutextension");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(cptr!=NULL) return(21);

  strcpy(fname, "text.");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".")) return(22);

  strcpy(fname, ".text");
  cptr=filenameGetExtension(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(cptr!=NULL) return(23);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_filenameGetExtensions(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char *cptr, fname[256];

  if(verbose>1) printf("empty string\n");
  cptr=NULL; if(filenameGetExtensions(cptr)) return(1);
  strcpy(fname, "");
  if(filenameGetExtension(fname)) return(2);

  strcpy(fname, "file.txt");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(11);

  strcpy(fname, "path/file.txt");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(12);

  strcpy(fname, "path\\file.txt");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(13);

  strcpy(fname, "file.txt.bak");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt.bak")) return(14);

  strcpy(fname, "C:\\temp\\Tampere 2014\\file.txt");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(15);

  strcpy(fname, "C:\\temp\\Tampere.2014\\file.txt");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".txt")) return(16);

  strcpy(fname, "image.v");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".v")) return(17);

  strcpy(fname, "image.v.bak");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".v.bak")) return(18);

  strcpy(fname, "image.v%");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".v%")) return(19);
  
  strcpy(fname, "filenamewithoutextension");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(cptr!=NULL) return(21);

  strcpy(fname, "text.");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".")) return(22);

  strcpy(fname, ".text");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(cptr!=NULL) return(23);

  strcpy(fname, ".image.v.bak");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".v.bak")) return(24);

  strcpy(fname, "../image.v.bak");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".v.bak")) return(25);

  strcpy(fname, "../../../image.v.bak");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".v.bak")) return(26);

  strcpy(fname, "./image.v.bak");
  cptr=filenameGetExtensions(fname);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, cptr);
  if(strcmp(cptr, ".v.bak")) return(27);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
