/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_atoiCheck(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("Testing with NULL input\n");
  if(!atoiCheck(NULL, NULL)) return(1);
  if(verbose>1) printf("Testing with empty input\n");
  if(!atoiCheck("", NULL)) return(2);

  int i;

  if(verbose>1) printf("Testing with correct input\n");
  if(atoiCheck("0", &i) || i!=0) return(11);
  if(atoiCheck("1", &i) || i!=1) return(12);
  if(atoiCheck("-10", &i) || i!=-10) return(13);
  if(atoiCheck("011", &i) || i!=11) return(14);

  if(verbose>1) printf("Testing with invalid input\n");
  if(!atoiCheck("0.1", &i) || i!=0) return(21);
  if(!atoiCheck("1,2,3", &i) || i!=0) return(22);
  if(!atoiCheck("1-10", &i) || i!=0) return(23);
  if(!atoiCheck("a11", &i) || i!=0) return(24);
  if(!atoiCheck("\n", &i) || i!=0) return(25);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_factorial(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  unsigned int n, f;

  n=0; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=1U) return(1);

  n=1; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=1U) return(2);

  n=2; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=2U) return(3);

  n=3; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=6U) return(4);

  n=4; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=24U) return(5);

  n=5; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=120U) return(6);

  n=6; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=720U) return(7);

  n=7; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=5040U) return(8);

  n=8; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=40320U) return(9);

  n=9; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=362880U) return(10);

  n=10; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=3628800U) return(11);

  n=11; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=39916800U) return(12);

  n=12; f=factorial(n);
  if(verbose>1) printf("%u! := %u\n", n, f);
  if(f!=479001600U) return(13);

  n=13; f=factorial(n);
  if(verbose>1) printf("Wrap-around case %u! := %u\n", n, f);
  if(f!=0) return(14);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_lfactorial(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  unsigned long long int n, f;

  n=0; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=1U) return(1);

  n=1; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=1U) return(2);

  n=2; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=2U) return(3);

  n=3; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=6U) return(4);

  n=4; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=24U) return(5);

  n=5; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=120U) return(6);

  n=6; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=720U) return(7);

  n=7; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=5040U) return(8);

  n=8; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=40320U) return(9);

  n=9; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=362880U) return(10);

  n=10; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=3628800U) return(11);

  n=11; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=39916800U) return(12);

  n=12; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=479001600U) return(13);

  n=13; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=6227020800U) return(14);

  n=14; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=87178291200U) return(15);

  n=15; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=1307674368000U) return(16);

  n=16; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=20922789888000U) return(17);

  n=17; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=355687428096000U) return(18);

  n=18; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=6402373705728000U) return(19);

  n=19; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=121645100408832000U) return(20);

  n=20; f=lfactorial(n);
  if(verbose>1) printf("%llu! := %llu\n", n, f);
  if(f!=2432902008176640000U) return(21);

  n=21; f=lfactorial(n);
  if(verbose>1) printf("Wrap-around case %llu! := %llu\n", n, f);
  if(f!=0) return(100);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_intlistInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("Testing with NULL input\n");
  intlistInit(NULL);

  if(verbose>1) printf("Testing with correct input\n");
  INTLIST list;
  intlistInit(&list);
  if(list.i!=NULL || list.nr!=0 || list._nr!=0) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_intlistFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("Testing with NULL input\n");
  intlistFree(NULL);

  if(verbose>1) printf("Testing with correct input\n");
  INTLIST list;
  intlistInit(&list);
  intlistFree(&list);
  if(list.i!=NULL || list.nr!=0 || list._nr!=0) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_intlistAdd(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("Testing with NULL input\n");
  if(intlistAdd(NULL, 2, 0)==0) return(1);

  if(verbose>1) printf("Testing with correct input\n");
  INTLIST list;
  intlistInit(&list);
  if(intlistAdd(&list, 2, 0)!=1) {intlistFree(&list); return(2);}
  if(list.nr!=1 || list.i[0]!=2) {intlistFree(&list); return(3);}
  if(intlistAdd(&list, 1, 0)!=1) {intlistFree(&list); return(4);}
  if(list.nr!=2 || list.i[1]!=1) {intlistFree(&list); return(5);}

  if(verbose>1) printf("Testing with existing int\n");
  if(intlistAdd(&list, 1, 1)!=0) {intlistFree(&list); return(6);}
  if(list.nr!=2 || list.i[1]!=1) {intlistFree(&list); return(7);}
  if(intlistAdd(&list, 2, 1)!=0) {intlistFree(&list); return(8);}
  if(list.nr!=2 || list.i[0]!=2) {intlistFree(&list); return(9);}
  if(intlistAdd(&list, 2, 0)!=1) {intlistFree(&list); return(10);}
  if(list.nr!=3 || list.i[2]!=2) {intlistFree(&list); return(11);}

  intlistFree(&list);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_intlistSort(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("Testing with NULL input\n");
  intlistSort(NULL);

  if(verbose>1) printf("Testing with empty input\n");
  INTLIST list;
  intlistInit(&list);
  intlistSort(&list);

  if(verbose>1) printf("Testing with contents\n");
  if(intlistAdd(&list, 100, 0)<1) {intlistFree(&list); return(11);}
  intlistSort(&list);
  if(list.nr!=1 || list.i[0]!=100) {intlistFree(&list); return(12);}

  if(intlistAdd(&list, 10, 0)<1) {intlistFree(&list); return(21);}
  intlistSort(&list);
  if(list.i[0]!=10 || list.i[1]!=100) {intlistFree(&list); return(22);}

  if(intlistAdd(&list, -10, 0)<1) {intlistFree(&list); return(31);}
  intlistSort(&list);
  if(list.i[0]!=-10 || list.i[1]!=10 || list.i[2]!=100) {
    intlistFree(&list); return(32);}

  intlistFree(&list);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_intlistAddFromString(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("Testing with NULL input\n");
  if(intlistAddFromString(NULL, NULL, NULL, 0)==0) return(1);

  int i, n;
  char tmp[128];
  INTLIST list; intlistInit(&list);

  if(verbose>1) printf("Testing with correct input\n");
  strcpy(tmp, "6");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistAddFromString(tmp, ", ", &list, 0);
  if(verbose>2) {for(i=0; i<n; i++) printf(" %d", list.i[i]); printf("\n");}
  if(n!=1 || list.nr!=1 || list.i[0]!=6) {intlistFree(&list); return(11);}

  if(verbose>1) printf("adding more\n");
  strcpy(tmp, "1, 2, 3,8");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistAddFromString(tmp, ", ", &list, 0);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=4 || list.nr!=5 || list.i[0]!=6 || list.i[4]!=8) {
    intlistFree(&list); return(21);}

  if(verbose>1) printf("adding existing integers\n");
  strcpy(tmp, "-1,2,3,8");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistAddFromString(tmp, ", ", &list, 1);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=1 || list.nr!=6 || list.i[0]!=6 || list.i[5]!=-1) {
    intlistFree(&list); return(31);}

  intlistFree(&list);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_intlistExpandFromString(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("Testing with NULL input\n");
  if(intlistExpandFromString(NULL, NULL, NULL, 0)==0) return(1);

  int i, n;
  char tmp[128];
  INTLIST list; intlistInit(&list);

  if(verbose>1) printf("Testing with very simple input\n");
  strcpy(tmp, "6");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 0);
  if(verbose>2) {for(i=0; i<n; i++) printf(" %d", list.i[i]); printf("\n");}
  if(n!=1 || list.nr!=1 || list.i[0]!=6) {intlistFree(&list); return(11);}

  if(verbose>1) printf("adding more\n");
  strcpy(tmp, "1, 2, 3,8");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 0);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=4 || list.nr!=5 || list.i[0]!=6 || list.i[4]!=8) {
    intlistFree(&list); return(21);}

  if(verbose>1) printf("adding existing integers\n");
  strcpy(tmp, "-1, 2 ,3, 8");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 1);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=1 || list.nr!=6 || list.i[0]!=6 || list.i[5]!=-1) {
    intlistFree(&list); return(31);}


  if(verbose>1) printf("adding range of integers\n");
  intlistFree(&list);
  strcpy(tmp, "0-8,12,32-28");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 1);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=15 || list.nr!=15 || list.i[0]!=0 || list.i[14]!=32) {
    intlistFree(&list); return(101);}

  if(verbose>1) printf("adding range of integers\n");
  intlistFree(&list);
  strcpy(tmp, "0..8, 12, 28..32");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 1);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=15 || list.nr!=15 || list.i[0]!=0 || list.i[14]!=32) {
    intlistFree(&list); return(102);}

  if(verbose>1) printf("adding range of negative integers\n");
  intlistFree(&list);
  strcpy(tmp, "-1--8, -12");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 1);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=9 || list.nr!=9 || list.i[0]!=-8 || list.i[8]!=-12) {
    intlistFree(&list); return(103);}

  intlistFree(&list);
  strcpy(tmp, "-1..-8");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 1);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=8 || list.nr!=8 || list.i[0]!=-8 || list.i[7]!=-1) {
    intlistFree(&list); return(104);}

  if(verbose>1) printf("overlapping ranges\n");
  intlistFree(&list);
  strcpy(tmp, "10-14, 12-16");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 1);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=7 || list.nr!=7 || list.i[0]!=10 || list.i[6]!=16) {
    intlistFree(&list); return(111);}

  intlistFree(&list);
  strcpy(tmp, "10-14, 12-16");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 0);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=10 || list.nr!=10 || list.i[0]!=10 || list.i[9]!=16) {
    intlistFree(&list); return(112);}

  intlistFree(&list);
  strcpy(tmp, "12-16,10-14");
  if(verbose>2) printf("'%s' ->\n", tmp);
  n=intlistExpandFromString(tmp, ", ", &list, 0);
  if(verbose>2) {
    for(i=0; i<list.nr; i++) printf(" %d", list.i[i]); 
    printf("\n");
  }
  if(n!=10 || list.nr!=10 || list.i[0]!=12 || list.i[9]!=14) {
    intlistFree(&list); return(113);}
  intlistSort(&list);
  if(list.i[0]!=10 || list.i[9]!=16) {
    intlistFree(&list); return(114);}

  intlistFree(&list);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
