/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tpcProcessStdOptions(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int help, vers, verb, ret;
  char s[64];
  
  char *cptr=NULL; help=vers=verb=0;
  ret=tpcProcessStdOptions(cptr, &help, &vers, &verb);
  if(ret!=1) return(1);
  
  strcpy(s, "uhuu"); help=vers=verb=0;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=1 || help!=0 || vers!=0 || verb !=0) return(2);
  
  strcpy(s, "--uhuu"); help=vers=verb=0;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=1 || help!=0 || vers!=0 || verb !=0) return(3);

  
  strcpy(s, "--help"); help=vers=verb=0;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=1 || vers!=0 || verb !=0) return(11);
  
  strcpy(s, "-h"); help=vers=verb=0;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=1 || vers!=0 || verb !=0) return(12);

  
  strcpy(s, "--version"); help=vers=verb=0;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=1 || verb !=0) return(21);

  strcpy(s, "-v"); help=vers=verb=0;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=1 || verb !=0) return(22);
  
  strcpy(s, "--quiet"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=0) return(31);

  strcpy(s, "-q"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=0) return(32);


  strcpy(s, "--silent"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=-1) return(41);

  strcpy(s, "-s"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb !=-1) return(42);


  strcpy(s, "--verbose"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=2) return(51);

  strcpy(s, "--verbose=3"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=4) return(52);

  strcpy(s, "--debug"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=2) return(53);

  strcpy(s, "--debug=30"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=31) return(54);

  strcpy(s, "-d"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=2) return(55);

  strcpy(s, "-d2"); help=vers=0; verb=1;
  ret=tpcProcessStdOptions(s, &help, &vers, &verb);
  if(verbose>1) {
    printf("string := '%s' ->\n", s);
    printf("  ret := %d\n  help := %d\n  version := %d\n  verbose := %d\n",
      ret, help, vers, verb);
  }
  if(ret!=0 || help!=0 || vers!=0 || verb!=3) return(56);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tpcPrintUsage(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tpcPrintBuild(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tpcProgramName(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char pname[256], fname[256];

  strcpy(fname, "");
  tpcProgramName(fname, 0, 0, pname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, pname);
  if(strcmp(pname, "unknown")) return(1);

  strcpy(fname, "P:\\temp\\ProgramName.exe");
  tpcProgramName(fname, 0, 0, pname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, pname);
  if(strcmp(pname, "ProgramName")) return(2);

  strcpy(fname, "/p/temp/programname");
  tpcProgramName(fname, 0, 0, pname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", fname, pname);
  if(strcmp(pname, "programname")) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tpcYesNo(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(tpcYesNo((char*)NULL)!=-1) return(1);
  if(tpcYesNo("")!=-1) return(2);
  if(tpcYesNo(" ")!=-1) return(3);
  if(tpcYesNo("\n")!=-1) return(4);
  if(tpcYesNo("o")!=-1) return(5);

  if(tpcYesNo("yes")!=1) return(11);
  if(tpcYesNo("Yes")!=1) return(12);
  if(tpcYesNo("Y")!=1) return(13);
  if(tpcYesNo("y")!=1) return(14);
  if(tpcYesNo("on")!=1) return(15);

  if(tpcYesNo("no")!=0) return(21);
  if(tpcYesNo("No")!=0) return(22);
  if(tpcYesNo("N")!=0) return(23);
  if(tpcYesNo("n")!=0) return(24);
  if(tpcYesNo("off")!=0) return(25);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
