/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_asciiFileSize(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, m, b;
  FILE *fp; char fname[]="test.txt";
  
  /* Trying to read from NULL pointer should give zero */
  n=(int)asciiFileSize(NULL, &b);
  if(verbose>1) printf("  n=%d  b=%d\n", n, b);
  if(n!=0 || b!=0) return 1;

  /* Make a normal text file, then read its size */
  fp=fopen(fname, "w"); if(fp==NULL) return 10;
  n=fprintf(fp, "line1\nline2\n"); fclose(fp); if(n<12) return 11;
  if(verbose>1) printf("  n=%d\n", n);
  fp=fopen(fname, "r"); if(fp==NULL) return 12;
  m=(int)asciiFileSize(fp, &b); fclose(fp);
  if(verbose>1) printf("  m=%d  b=%d\n", m, b);
  if(m!=n || b!=0) return 13;

  /* Make text file with control character, then read its size */
  fp=fopen(fname, "w"); if(fp==NULL) return 20;
  n=fprintf(fp, "line1\nline2\n%cline3\n", 3); fclose(fp); if(n<19) return 21;
  if(verbose>1) printf("  n=%d\n", n);
  fp=fopen(fname, "r"); if(fp==NULL) return 22;
  m=(int)asciiFileSize(fp, &b); fclose(fp);
  if(verbose>1) printf("  m=%d  b=%d\n", m, b);
  if(m!=12 || b!=1) return 23;

  /* Make a text file with extended ASCII, then read its size */
  fp=fopen(fname, "w"); if(fp==NULL) return 30;
  n=fprintf(fp, "line1\nline2\n# name := %cmil N%ck%cr%cinen\n", 201, 228, 228, 228); 
  fclose(fp); if(n<20) return 31;
  if(verbose>1) printf("  n=%d\n", n);
  fp=fopen(fname, "r"); if(fp==NULL) return 32;
  m=(int)asciiFileSize(fp, &b); fclose(fp);
  if(verbose>1) printf("  m=%d  b=%d\n", m, b);
  if(m!=n || b!=0) return 33;

  /* Make a text file with extended ASCII and control character, then read its size */
  fp=fopen(fname, "w"); if(fp==NULL) return 40;
  n=fprintf(fp, "line1\nline2\n# name := %cmil N%ck%cr%cinen\n", 201, 228, 228, 228);
  m=fprintf(fp, "%cBlah-Blah-Blah\n", 3); 
  fclose(fp); if(n<20 || m<15) return 41;
  if(verbose>1) printf("  n=%d\n", n);
  fp=fopen(fname, "r"); if(fp==NULL) return 42;
  m=(int)asciiFileSize(fp, &b); fclose(fp);
  if(verbose>1) printf("  m=%d  b=%d\n", m, b);
  if(m!=n || b!=1) return 43;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_asciiFileRead(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, m, b;
  FILE *fp;
  char fname[]="test.txt", buf[512], text[512], *cptr;
  
  /* Trying to read from NULL pointer should give NULL */
  cptr=asciiFileRead(NULL, NULL, 0);
  if(cptr!=NULL) return 1;
  cptr=asciiFileRead(NULL, NULL, 100);
  if(cptr!=NULL) return 1;
  cptr=asciiFileRead(NULL, buf, 512);
  if(cptr!=NULL) return 1;
  
  /* Make a normal text file */
  sprintf(text, "line1\nline2\nline3\n");
  if(verbose>1) printf("text:\n%s\n", text);
  fp=fopen(fname, "w"); if(fp==NULL) return 2;
  n=fprintf(fp, "%s", text); fclose(fp); if(n<18) return 2;
  if(verbose>1) printf("  n=%d\n", n);
  /* Open file and read all of its contents into preallocated string */
  fp=fopen(fname, "r"); if(fp==NULL) return 2;
  m=(int)asciiFileSize(fp, &b);
  if(verbose>1) printf("  m=%d\n", m);
  cptr=asciiFileRead(fp, buf, m+1); fclose(fp);
  if(verbose>1) printf("cptr:\n%s\n", cptr);
  if(strcmp(text, cptr)!=0) return 2;
  if(verbose>1) printf("buf:\n%s\n", buf);
  if(strcmp(text, buf)!=0) return 2;
  
  /* Open file and read part of its contents into preallocated string */
  fp=fopen(fname, "r"); if(fp==NULL) return 3;
  cptr=asciiFileRead(fp, buf, 8+1); fclose(fp);
  if(verbose>1) printf("cptr:\n%s\n", cptr);
  if(strncmp(text, cptr, 8)!=0) return 3;
  if(verbose>1) printf("buf:\n%s\n", buf);
  if(strncmp(text, buf, 8)!=0) return 3;

  /* Open file and read all of its contents into not preallocated string*/
  fp=fopen(fname, "r"); if(fp==NULL) return 2;
  m=(int)asciiFileSize(fp, &b);
  if(verbose>1) printf("  m=%d\n", m);
  cptr=asciiFileRead(fp, NULL, m+1); fclose(fp);
  if(verbose>1) printf("cptr:\n%s\n", cptr);
  if(strcmp(text, cptr)!=0) {free(cptr); return 2;}
  free(cptr);
  
  /* Open file and read part of its contents into not preallocated string */
  fp=fopen(fname, "r"); if(fp==NULL) return 3;
  cptr=asciiFileRead(fp, NULL, 8+1); fclose(fp);
  if(verbose>1) printf("cptr:\n%s\n", cptr);
  if(strncmp(text, cptr, 8)!=0) {free(cptr); return 2;}
  free(cptr);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_asciiCommentLine(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret, i;
  char text[512];
  
  ret=asciiCommentLine(NULL, NULL);
  if(ret!=0) return 1;
  ret=asciiCommentLine(NULL, &i);
  if(ret!=0 || i!=0) return 2;

  strcpy(text, "key1 := value1");
  if(verbose>1) printf("line := '%s'\n", text);
  ret=asciiCommentLine(text, &i);
  if(verbose>2) printf("-> ret := %d\n   cont := '%s'\n", ret, text+i);
  if(ret!=0 || i!=0) return 3;
  ret=asciiCommentLine(text, NULL);
  if(ret!=0) return 3;

  strcpy(text, "\tkey1 := value1");
  if(verbose>1) printf("line := '%s'\n", text);
  ret=asciiCommentLine(text, &i);
  if(verbose>2) printf("-> ret := %d\n   cont := '%s'\n", ret, text+i);
  if(ret!=0 || i!=1) return 4;

  strcpy(text, "\t#key1 := value1");
  if(verbose>1) printf("line := '%s'\n", text);
  ret=asciiCommentLine(text, &i);
  if(verbose>2) printf("-> ret := %d\n   cont := '%s'\n", ret, text+i);
  if(ret!=1 || i!=2) return 5;

  strcpy(text, "   #   key1 := value1  ");
  if(verbose>1) printf("line := '%s'\n", text);
  ret=asciiCommentLine(text, &i);
  if(verbose>2) printf("-> ret := %d\n   cont := '%s'\n", ret, text+i);
  if(ret!=1 || i!=7) return 6;

  strcpy(text, "key1 := value1  # invalid comment");
  if(verbose>1) printf("line := '%s'\n", text);
  ret=asciiCommentLine(text, &i);
  if(verbose>2) printf("-> ret := %d\n   cont := '%s'\n", ret, text+i);
  if(ret!=0 || i!=0) return 7;

  strcpy(text, "#");
  if(verbose>1) printf("line := '%s'\n", text);
  ret=asciiCommentLine(text, &i);
  if(verbose>2) printf("-> ret := %d\n   cont := '%s'\n", ret, text+i);
  if(ret!=1 || i!=1) return 8;

  strcpy(text, "  #");
  if(verbose>1) printf("line := '%s'\n", text);
  ret=asciiCommentLine(text, &i);
  if(verbose>2) printf("-> ret := %d\n   cont := '%s'\n", ret, text+i);
  if(ret!=1 || i!=3) return 9;
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
